/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer.context;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.VaultMod;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.task.renderer.context.RendererContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GodAltarRendererContext
extends RendererContext {
    public static final ResourceLocation TEXTURE = VaultMod.id("textures/gui/god_altar_hud.png");
    private final Medium medium;

    protected GodAltarRendererContext(PoseStack matrices, float tickDelta, MultiBufferSource.BufferSource bufferSource, Font font, Medium medium) {
        super(matrices, tickDelta, bufferSource, font);
        this.medium = medium;
    }

    public static GodAltarRendererContext forHud(PoseStack matrices, float tickDelta, Font font) {
        return new GodAltarRendererContext(matrices, tickDelta, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), font, Medium.HUD);
    }

    public static GodAltarRendererContext forWorld(PoseStack matrices, float tickDelta, Font font) {
        return new GodAltarRendererContext(matrices, tickDelta, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), font, Medium.WORLD);
    }

    public boolean isHud() {
        return this.medium == Medium.HUD;
    }

    public boolean isWorld() {
        return this.medium == Medium.WORLD;
    }

    public void renderHeader(String description, boolean centered) {
        int previous = this.setShaderTexture(TEXTURE);
        this.setShaderColor(0xFFFFFF);
        this.push();
        if (this.isWorld()) {
            this.translate(0.0, 0.0, -0.01);
        }
        MutableComponent text = new TextComponent(" - ").m_130948_(Style.f_131099_.m_178520_(0x606060)).m_7220_((Component)new TextComponent(description).m_130948_(Style.f_131099_.m_178520_(0xCCCCCC)));
        MutableComponent shadow = new TextComponent(" - ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLACK)).m_7220_((Component)new TextComponent(description).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLACK)));
        this.renderText((Component)shadow, centered ? 66.0f : 12.0f, 13.0f, centered, true);
        this.renderText((Component)text, centered ? 65.0f : 11.0f, 12.0f, centered, true);
        this.pop();
        this.setShaderTexture(previous);
        this.translate(0.0, 0.0, 0.0);
    }

    public void renderProgressBar(String description, String hint) {
        int previous = this.setShaderTexture(TEXTURE);
        this.setShaderColor(0xFFFFFF);
        this.push();
        this.setShaderColor(0xFFFFFF);
        this.setShaderTexture(previous);
        if (this.isWorld()) {
            this.translate(0.0, 0.0, -0.01);
        }
        MutableComponent title = new TextComponent(" - ").m_130948_(Style.f_131099_.m_178520_(0x606060)).m_7220_((Component)new TextComponent(description).m_130948_(Style.f_131099_.m_178520_(0xCCCCCC))).m_7220_((Component)new TextComponent(" | ").m_130948_(Style.f_131099_.m_178520_(0x606060))).m_7220_((Component)new TextComponent(hint).m_130940_(ChatFormatting.WHITE));
        MutableComponent titleShadow = new TextComponent(" - " + description).m_130940_(ChatFormatting.BLACK).m_7220_((Component)new TextComponent(" | ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLACK))).m_7220_((Component)new TextComponent(hint).m_130940_(ChatFormatting.BLACK));
        if (this.isWorld()) {
            this.renderText((Component)titleShadow, 66.0f, 13.0f, true, true);
            this.renderText((Component)title, 65.0f, 12.0f, true, true);
        } else {
            this.renderText((Component)titleShadow, 12.0f, 13.0f, false, true);
            this.renderText((Component)title, 11.0f, 12.0f, false, true);
        }
        this.pop();
        this.translate(0.0, 0.0, -0.01);
    }

    public void renderTimerBar(VaultGod god, String hint) {
        int previous = this.setShaderTexture(TEXTURE);
        this.setShaderColor(0xFFFFFF);
        this.push();
        int width = Minecraft.m_91087_().f_91062_.m_92895_(god.getName() + "'s Challenge | " + hint);
        if (this.isWorld()) {
            this.blit(65 - width / 2, 1, 0, 0, width, 2, 256, 256);
        } else {
            this.blit(11, 1, 0, 0, width, 2, 256, 256);
        }
        this.setShaderColor(0xFFFFFF);
        this.setShaderTexture(previous);
        if (this.isWorld()) {
            this.renderText((Component)new TextComponent(god.getName() + "'s Challenge").m_130940_(ChatFormatting.BLACK).m_7220_((Component)new TextComponent(" | ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLACK))).m_7220_((Component)new TextComponent(hint).m_130940_(ChatFormatting.BLACK)), 66.0f, -4.0f, true, true);
            this.renderText((Component)new TextComponent(god.getName() + "'s Challenge").m_130948_(Style.f_131099_.m_178520_(god.getColor())).m_7220_((Component)new TextComponent(" | ").m_130948_(Style.f_131099_.m_178520_(0x606060))).m_7220_((Component)new TextComponent(hint).m_130940_(ChatFormatting.WHITE)), 65.0f, -5.0f, true, true);
        } else {
            this.renderText((Component)new TextComponent(god.getName() + "'s Challenge").m_130940_(ChatFormatting.BLACK).m_7220_((Component)new TextComponent(" | ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLACK))).m_7220_((Component)new TextComponent(hint).m_130940_(ChatFormatting.BLACK)), 12.0f, -4.0f, false, true);
            this.renderText((Component)new TextComponent(god.getName() + "'s Challenge").m_130948_(Style.f_131099_.m_178520_(god.getColor())).m_7220_((Component)new TextComponent(" | ").m_130948_(Style.f_131099_.m_178520_(0x606060))).m_7220_((Component)new TextComponent(hint).m_130940_(ChatFormatting.WHITE)), 11.0f, -5.0f, false, true);
        }
        this.pop();
        this.translate(0.0, 0.0, -0.01);
    }

    protected static enum Medium {
        HUD,
        WORLD;

    }
}

