/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer.context;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.client.gui.helper.ScreenDrawHelper;
import iskallia.vault.client.util.ClientScheduler;
import iskallia.vault.dynamodel.model.armor.ArmorLayers;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.renderer.VaultArmorRenderProperties;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.gear.VaultArmorItem;
import iskallia.vault.task.renderer.Vec2d;
import iskallia.vault.util.EntityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RendererContext {
    private PoseStack matrices;
    private float tickDelta;
    private final MultiBufferSource.BufferSource bufferSource;
    protected final Font font;
    private final Stack<Vec2d> mouse = new Stack();
    private static final List<TooltipRender> tooltips = new ArrayList<TooltipRender>();

    public RendererContext(PoseStack matrices, float tickDelta, MultiBufferSource.BufferSource bufferSource, Font font) {
        this.matrices = matrices;
        this.tickDelta = tickDelta;
        this.bufferSource = bufferSource;
        this.font = font;
        this.mouse.push(Vec2d.ZERO);
    }

    public PoseStack getMatrices() {
        return this.matrices;
    }

    public MultiBufferSource.BufferSource getBufferSource() {
        return this.bufferSource;
    }

    public long getTick() {
        return ClientScheduler.INSTANCE.getTick();
    }

    public double getPartialTick() {
        return (float)this.getTick() + this.getTickDelta();
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    public Vec2d getMouse() {
        return this.mouse.peek();
    }

    public void setMatrices(PoseStack matrices) {
        this.matrices = matrices;
    }

    public void setTickDelta(float tickDelta) {
        this.tickDelta = tickDelta;
    }

    public void setMouse(Vec2d mouse) {
        this.mouse.pop();
        this.mouse.push(mouse);
    }

    public void push() {
        this.matrices.m_85836_();
        this.mouse.push(this.getMouse());
    }

    public void pop() {
        this.matrices.m_85849_();
        this.mouse.pop();
    }

    public void pushMouse(Vec2d mouse) {
        this.mouse.push(mouse);
    }

    public void popMouse() {
        this.mouse.pop();
    }

    public void translate(double x, double y, double z) {
        this.matrices.m_85837_(x, y, z);
        Vec2d current = this.mouse.isEmpty() ? Vec2d.ZERO : this.mouse.pop();
        this.mouse.push(current.subtract(x, y));
    }

    public void translate(Vec3 vector) {
        this.translate(vector.f_82479_, vector.f_82480_, vector.f_82481_);
    }

    public void translate(Vector3d vector) {
        this.translate(vector.f_86214_, vector.f_86215_, vector.f_86216_);
    }

    public void scale(double x, double y, double z) {
        this.matrices.m_85841_((float)x, (float)y, (float)z);
    }

    public void scale(Vec3 vector) {
        this.scale(vector.f_82479_, vector.f_82480_, vector.f_82481_);
    }

    public void scale(Vector3d vector) {
        this.scale(vector.f_86214_, vector.f_86215_, vector.f_86216_);
    }

    public int setShaderTexture(ResourceLocation texture) {
        int previous = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        return previous;
    }

    public int setShaderTexture(int texture) {
        int previous = RenderSystem.m_157203_((int)0);
        RenderSystem.m_157453_((int)0, (int)texture);
        return previous;
    }

    public void setShaderColor(float alpha, float red, float green, float blue) {
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void setShaderColor(int alpha, int red, int green, int blue) {
        this.setShaderColor((float)alpha / 255.0f, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
    }

    public void setShaderColor(int color) {
        this.setShaderColor(color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public void setShaderColor(ChatFormatting formatting) {
        this.setShaderColor(formatting.m_126665_() == null ? 0xFFFFFF : formatting.m_126665_());
    }

    public void drawColoredRect(float x, float y, float width, float height, int color) {
        RenderSystem.m_69478_();
        ScreenDrawHelper.draw(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, buf -> ScreenDrawHelper.rect((VertexConsumer)buf, this.matrices).at(x, y).dim(width, height).color(color).drawColored());
    }

    public void blit(ResourceLocation id, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        int previous = this.setShaderTexture(id);
        this.blit(x, y, u, v, width, height, textureWidth, textureHeight);
        this.setShaderTexture(previous);
    }

    public void blit(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        this.push();
        this.translate(x, y, 0.0);
        GuiComponent.m_93133_((PoseStack)this.matrices, (int)0, (int)0, (float)u, (float)v, (int)width, (int)height, (int)textureWidth, (int)textureHeight);
        this.pop();
    }

    public void drawNineSlice(NineSlice.TextureRegion textureRegion, int x, int y, int width, int height) {
        this.push();
        this.translate(x, y, 0.0);
        textureRegion.blit(this.matrices, 0, 0, 0, width, height);
        this.pop();
    }

    public void fill(Vec2d position, int width, int height, int color) {
        this.fill((int)position.getX(), (int)position.getY(), width, height, color);
    }

    public void fill(int x, int y, int width, int height, int color) {
        this.push();
        this.translate(x, y, 0.0);
        GuiComponent.m_93172_((PoseStack)this.matrices, (int)0, (int)0, (int)width, (int)height, (int)color);
        this.pop();
    }

    public void drawOutline(int x, int y, int width, int height, int size, int color) {
        this.fill(x, y, x + width, Math.min(size, height), color);
        this.fill(x + width - Math.min(size, width), y, Math.min(size, width), height, color);
        this.fill(x, y, Math.min(size, width), height, color);
        this.fill(x, height - Math.min(size, height), width, Math.min(size, height), color);
    }

    public void renderText(Component text, float x, float y, boolean centeredX, boolean centeredY) {
        this.renderText(text, x, y, 9000, centeredX, centeredY, -1, false);
    }

    public void renderText(Component text, float x, float y, boolean centeredX, boolean centeredY, int color, boolean shadow) {
        this.renderText(text, x, y, 9000, centeredX, centeredY, color, shadow);
    }

    public void renderText(Component text, float x, float y, int maxWidth, boolean centeredX, boolean centeredY, int color, boolean shadow) {
        this.push();
        this.translate(x, y, 0.0);
        List formatted = this.font.m_92923_((FormattedText)text, maxWidth);
        int lineY = 0;
        for (FormattedCharSequence sequence : formatted) {
            float f;
            float offsetX;
            float f2 = offsetX = centeredX ? (float)((double)(-this.font.m_92724_(sequence)) / 2.0) : 0.0f;
            if (centeredY) {
                Objects.requireNonNull(this.font);
                f = (float)((double)(-9) / 2.0);
            } else {
                f = 0.0f;
            }
            float offsetY = f;
            this.font.m_92877_(this.matrices, sequence, offsetX, offsetY + (float)lineY, color);
            if (shadow) {
                this.font.m_92744_(this.matrices, sequence, offsetX, offsetY + (float)lineY, -16777216);
            }
            Objects.requireNonNull(this.font);
            lineY += 9;
        }
        RenderSystem.m_69482_();
        this.bufferSource.m_109911_();
        this.pop();
    }

    public void renderTextRight(Component text, float x, float y, boolean centeredY) {
        float f;
        this.push();
        this.translate(x, y, 0.0);
        FormattedCharSequence formatted = (FormattedCharSequence)this.font.m_92923_((FormattedText)text, 9000).get(0);
        float offsetX = -this.font.m_92724_(formatted);
        if (centeredY) {
            Objects.requireNonNull(this.font);
            f = (float)((double)(-9) / 2.0);
        } else {
            f = 0.0f;
        }
        float offsetY = f;
        this.font.m_92733_(formatted, offsetX, offsetY, 0xFFFFFF, false, this.matrices.m_85850_().m_85861_(), (MultiBufferSource)this.bufferSource, true, 0, 0xF000F0);
        RenderSystem.m_69482_();
        this.bufferSource.m_109911_();
        this.pop();
    }

    public void renderEntity(LivingEntity entity, int x, int y, float scale) {
        this.push();
        this.translate(x, y, 0.0);
        EntityHelper.renderEntityInUI(entity, this.matrices, this.bufferSource, 0, 0, scale, (int)this.getMouse().getX(), (int)this.getMouse().getY());
        this.pop();
    }

    public void renderInWorldStack(ItemStack stack, int x, int y, float scale, int packedLight, int packedOverlay) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        int previous = this.setShaderTexture(TextureAtlas.f_118259_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer itemRenderer = minecraft.m_91291_();
        Lighting.m_84931_();
        this.push();
        this.translate((float)x + 0.0f, (float)y + 0.0f, 0.0);
        this.matrices.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        this.scale(16.0f * scale, 16.0f * scale, 16.0);
        itemRenderer.m_174269_(stack, ItemTransforms.TransformType.GUI, packedLight, packedOverlay, this.matrices, (MultiBufferSource)this.bufferSource, 0);
        this.bufferSource.m_109911_();
        this.pop();
        this.setShaderTexture(previous);
    }

    public void renderStack(ItemStack stack, int x, int y, float scale, boolean withSlotTexture, boolean withTooltip) {
        int previous;
        Minecraft minecraft = Minecraft.m_91087_();
        if (withSlotTexture) {
            previous = this.setShaderTexture(VaultMod.id("textures/gui/screen/inset_item_slot_background.png"));
            this.push();
            this.translate(x, y, 0.0);
            this.scale(scale, scale, 1.0);
            this.blit(0, 0, 0, 0, 18, 18, 18, 18);
            this.pop();
            this.setShaderTexture(previous);
        }
        minecraft.m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        previous = this.setShaderTexture(TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer itemRenderer = minecraft.m_91291_();
        BakedModel model = itemRenderer.m_174264_(stack, null, null, 0);
        if (!model.m_7547_()) {
            Lighting.m_84930_();
        } else {
            RenderSystem.m_157450_((Vector3f)new Vector3f(-0.2f, -1.0f, 0.7f), (Vector3f)new Vector3f(-0.2f, 1.0f, -0.7f));
        }
        this.push();
        float offset = withSlotTexture ? 1.0f * scale : 0.0f;
        this.translate((float)x + offset, (float)y + offset, 0.0);
        this.translate(8.0f * scale, 8.0f * scale, 100.0);
        this.scale(1.0, -1.0, 1.0);
        this.scale(16.0f * scale, 16.0f * scale, 16.0);
        itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GUI, false, this.matrices, (MultiBufferSource)this.bufferSource, LightmapHelper.getPackedFullbrightCoords(), OverlayTexture.f_118083_, model);
        this.bufferSource.m_109911_();
        this.pop();
        RenderSystem.m_69482_();
        if (!model.m_7547_()) {
            Lighting.m_84931_();
        }
        this.setShaderTexture(previous);
        if (!stack.m_41619_() && withTooltip && this.isItemHovered(x, y, scale)) {
            this.renderTooltip(List.of(stack.m_41786_()));
        }
    }

    private boolean isItemHovered(int x, int y, float scale) {
        double mouseX = this.getMouse().getX();
        double mouseY = this.getMouse().getY();
        return mouseX >= (double)x && mouseX <= (double)x + 17.99 * (double)scale && mouseY >= (double)y && mouseY <= (double)y + 17.99 * (double)scale;
    }

    public void renderTooltip(List<Component> lines) {
        int width = 0;
        int height = lines.size() == 1 ? -2 : 0;
        for (Component line : lines) {
            int k = this.font.m_92852_((FormattedText)line);
            if (k > width) {
                width = k;
            }
            Objects.requireNonNull(this.font);
            height += 9;
        }
        int x = (int)(this.getMouse().getX() - (double)width - 14.0);
        if (x <= 0) {
            x += width + 24;
        }
        int y = (int)(this.getMouse().getY() - (double)height + 6.0);
        tooltips.add(new TooltipRender(this, lines, x, y, width, height));
    }

    private static void fillGradient(Matrix4f pose, BufferBuilder builder, int colorA, int colorB, int x1, int y1, int x2, int y2) {
        float f = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colorA & 0xFF) / 255.0f;
        float f4 = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colorB & 0xFF) / 255.0f;
        builder.m_85982_(pose, (float)x2, (float)y1, 200.0f).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y1, 200.0f).m_85950_(f1, f2, f3, f).m_5752_();
        builder.m_85982_(pose, (float)x1, (float)y2, 200.0f).m_85950_(f5, f6, f7, f4).m_5752_();
        builder.m_85982_(pose, (float)x2, (float)y2, 200.0f).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    public void renderArmorModel(ItemStack stack, int x, int y) {
        Item associatedItem = stack.m_41720_();
        VaultGearData gearData = VaultGearData.read(stack);
        if (associatedItem instanceof VaultArmorItem) {
            this.push();
            this.translate(x, y, 350.0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.push();
            this.scale(16.0, 16.0, 16.0);
            double rotation = -90.0 * ((double)System.currentTimeMillis() / 1000.0) % 360.0 * (Math.PI / 180);
            this.matrices.m_85845_(Quaternion.m_175228_((float)-0.3925f, (float)((float)rotation), (float)0.0f));
            Optional<DynamicModelRegistry<?>> modelRegistry = ModDynamicModels.REGISTRIES.getAssociatedRegistry(stack.m_41720_());
            ArmorPieceModel armorPiece = null;
            if (modelRegistry.isPresent()) {
                Object obj;
                Optional<?> model;
                Optional<ResourceLocation> firstValue = gearData.getFirstValue(ModGearAttributes.GEAR_MODEL);
                if (firstValue.isPresent() && (model = modelRegistry.get().get(firstValue.get())).isPresent() && (obj = model.get()) instanceof ArmorPieceModel) {
                    ArmorPieceModel armorPieceModel;
                    armorPiece = armorPieceModel = (ArmorPieceModel)obj;
                }
                if (armorPiece != null) {
                    VaultArmorItem vaultArmorItem = VaultArmorItem.forSlot(armorPiece.getEquipmentSlot());
                    ArmorLayers.BaseLayer baseLayer = VaultArmorRenderProperties.BAKED_LAYERS.get(armorPiece.getId());
                    String baseTexture = vaultArmorItem.getArmorTexture(stack, null, armorPiece.getEquipmentSlot(), null);
                    String overlayTexture = vaultArmorItem.getArmorTexture(stack, null, armorPiece.getEquipmentSlot(), "overlay");
                    this.translate(0.0, -2.0, 0.0);
                    this.scale(1.5, 1.5, 1.5);
                    EquipmentSlot intendedSlot = vaultArmorItem.getGearType(stack).getEquipmentSlot();
                    if (intendedSlot == EquipmentSlot.HEAD) {
                        this.translate(0.0, 0.25, 0.0);
                    } else if (intendedSlot == EquipmentSlot.LEGS) {
                        this.translate(0.0, -0.75, 0.0);
                    } else if (intendedSlot == EquipmentSlot.FEET) {
                        this.translate(0.0, -1.25, 0.0);
                    }
                    if (baseTexture != null) {
                        VertexConsumer baseVertexConsumer = this.bufferSource.m_6299_(baseLayer.m_103119_(new ResourceLocation(baseTexture)));
                        baseLayer.m_7695_(this.matrices, baseVertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                    if (overlayTexture != null) {
                        VertexConsumer overlayVertexConsumer = this.bufferSource.m_6299_(baseLayer.m_103119_(new ResourceLocation(overlayTexture)));
                        baseLayer.m_7695_(this.matrices, overlayVertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
            }
            this.bufferSource.m_109911_();
            RenderSystem.m_69482_();
            this.pop();
            this.pop();
        }
    }

    public void renderScrollbarWithHandle(int x, int y, int width, int height, float scrollValue, boolean enabled) {
        this.push();
        this.translate(x, y, 0.0);
        ScreenTextures.INSET_GREY_BACKGROUND.blit(this.matrices, 0, 0, 0, width, height);
        this.renderScrollbarHandle(x, y, height, scrollValue, enabled);
        this.pop();
    }

    public void renderScrollbarHandle(int x, int y, int height, float scrollValue, boolean enabled) {
        this.push();
        TextureAtlasRegion handle = enabled ? ScreenTextures.SCROLLBAR_HANDLE : ScreenTextures.SCROLLBAR_HANDLE_DISABLED;
        double minHeight = (double)handle.height() / 2.0;
        double maxHeight = (double)height - (double)handle.height() / 2.0;
        double scrollHandleY = (double)y + (maxHeight - minHeight) * (double)scrollValue;
        scrollHandleY = Math.max(1.0, scrollHandleY);
        scrollHandleY = Math.min(maxHeight, scrollHandleY);
        this.translate(1.0, scrollHandleY, 0.0);
        handle.blit(this.matrices, 0, 0, 0, handle.width(), handle.height());
        this.pop();
    }

    @SubscribeEvent
    public static void onRenderScreenLast(ScreenEvent.DrawScreenEvent.Post event) {
        int mouseX = event.getMouseX();
        int mouseY = event.getMouseY();
        for (TooltipRender tooltip : tooltips) {
            RendererContext.renderTooltip(tooltip, mouseX, mouseY);
        }
        tooltips.clear();
    }

    private static void renderTooltip(TooltipRender tooltip, int mouseX, int mouseY) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        ArrayList<FormattedCharSequence> components = new ArrayList<FormattedCharSequence>();
        for (Component component : tooltip.components) {
            components.add(component.m_7532_());
        }
        if (screen != null) {
            screen.renderTooltip(tooltip.context.getMatrices(), components, mouseX, mouseY, Minecraft.m_91087_().f_91062_);
        }
    }

    public static class TooltipRender {
        int x;
        int y;
        int width;
        int height;
        List<Component> components;
        RendererContext context;

        public TooltipRender(RendererContext context, List<Component> components, int x, int y, int width, int height) {
            this.context = context;
            this.components = components;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

