/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer.context;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import iskallia.vault.client.gui.helper.LightmapHelper;
import iskallia.vault.task.renderer.context.RendererContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TeamRendererContext
extends RendererContext {
    private final Medium medium;
    private final int packedLight;
    private final int packedOverlay;

    private TeamRendererContext(PoseStack matrices, float tickDelta, MultiBufferSource.BufferSource bufferSource, Font font, Medium medium, int packedLight, int packedOverlay) {
        super(matrices, tickDelta, bufferSource, font);
        this.medium = medium;
        this.packedLight = packedLight;
        this.packedOverlay = packedOverlay;
    }

    public static TeamRendererContext forHud(PoseStack matrices, float tickDelta, Font font) {
        return new TeamRendererContext(matrices, tickDelta, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), font, Medium.HUD, LightmapHelper.getPackedFullbrightCoords(), OverlayTexture.f_118083_);
    }

    public static TeamRendererContext forWorld(PoseStack matrices, float tickDelta, Font font, int packedLight, int packedOverlay) {
        return new TeamRendererContext(matrices, tickDelta, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), font, Medium.WORLD, packedLight, packedOverlay);
    }

    public boolean isWorld() {
        return this.medium == Medium.WORLD;
    }

    public void renderStack(ItemStack stack) {
        this.renderInWorldStack(stack, 0, -15, 2.0f, this.packedLight, this.packedOverlay);
    }

    public void renderIcon(ResourceLocation icon) {
        this.push();
        this.scale(2.0, 2.0, 2.0);
        this.blit(icon, -8, -16, 0, 0, 16, 16, 16, 16);
        this.pop();
    }

    public void renderNameAndProgress(String name, String progress) {
        this.push();
        if (this.isWorld()) {
            this.translate(0.0, 0.0, -0.01);
        }
        RenderSystem.m_69465_();
        MutableComponent title = new TextComponent(name).m_130948_(Style.f_131099_.m_178520_(0xCCCCCC));
        MutableComponent progressText = new TextComponent(progress).m_130940_(ChatFormatting.WHITE);
        MutableComponent titleShadow = new TextComponent(name).m_130940_(ChatFormatting.BLACK);
        MutableComponent progressShadow = new TextComponent(progress).m_130940_(ChatFormatting.BLACK);
        if (this.isWorld()) {
            int width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)title);
            int halfWidth = Math.min(width, 200) / 2;
            boolean twolineText = this.font.m_92852_((FormattedText)title) > 200;
            this.fill(-halfWidth - 3, twolineText ? -4 : 7, 2 * halfWidth + 6, twolineText ? 33 : 22, 0x33000000);
            this.setShaderColor(0xFFFFFF);
            this.push();
            this.translate(0.0, 0.0, 0.01);
            float y = twolineText ? 3.0f : 13.0f;
            this.renderText((Component)titleShadow, 0.0f, y, 200, true, true, 0xFFFFFF, false);
            this.renderText((Component)progressShadow, 0.0f, 23.0f, true, true);
            this.pop();
            this.renderText((Component)title, 0.0f, y, 200, true, true, 0xFFFFFF, false);
            this.renderText((Component)progressText, 0.0f, 22.0f, true, true);
        } else {
            this.setShaderColor(0xFFFFFF);
            this.renderText((Component)titleShadow, 12.0f, 13.0f, false, true);
            this.renderText((Component)title, 11.0f, 12.0f, false, true);
        }
        this.pop();
    }

    protected static enum Medium {
        HUD,
        WORLD;

    }
}

