/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.util.SimpleIntProgressCounter;
import iskallia.vault.task.util.SlidingTimeIntProgressCounter;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public interface IProgressCounter<N extends Number>
extends ISerializable<Tag, JsonElement> {
    public void addCount(N var1);

    public N getCount();

    public void setCount(N var1);

    public void onTick();

    public static abstract class Config<N extends Number>
    implements ISerializable<Tag, JsonObject> {
        private final String type;

        private static <N extends Number> Optional<Config<N>> initialize(String type) {
            if (type.equals("simple")) {
                return Optional.of(new SimpleIntProgressCounter.Config());
            }
            if (type.equals("sliding_time")) {
                return Optional.of(new SlidingTimeIntProgressCounter.Config());
            }
            return Optional.empty();
        }

        public static <N extends Number> Optional<Config<N>> fromBits(BitBuffer buffer) {
            return Config.initialize(buffer.readString());
        }

        public static <N extends Number> Optional<Config<N>> fromNbt(Tag nbt) {
            String string;
            if (nbt instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbt;
                string = compoundTag.m_128461_("type");
            } else {
                string = nbt.m_7916_();
            }
            return Config.initialize(string);
        }

        public static <N extends Number> Optional<Config<N>> fromJson(JsonObject json) {
            return Config.initialize(json.get("type").getAsString());
        }

        public Config(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            buffer.writeString(this.type);
        }

        @Override
        public void readBits(BitBuffer buffer) {
        }

        @Override
        public Optional<Tag> writeNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", this.type);
            return Optional.of(tag);
        }

        @Override
        public void readNbt(Tag nbt) {
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            json.addProperty("type", this.type);
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
        }

        public abstract IProgressCounter<N> initCounter();
    }
}

