/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.util.IProgressCounter;
import java.util.Optional;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class SimpleIntProgressCounter
implements IProgressCounter<Integer> {
    public static final String TYPE = "simple";
    private int count;

    @Override
    public void addCount(Integer count) {
        this.count += count.intValue();
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public void setCount(Integer count) {
        this.count = count;
    }

    @Override
    public void onTick() {
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        buffer.writeInt(this.count);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.count = buffer.readInt();
    }

    @Override
    public Optional<Tag> writeNbt() {
        return Optional.of(IntTag.m_128679_((int)this.count));
    }

    @Override
    public void readNbt(Tag nbt) {
        int n;
        if (nbt instanceof IntTag) {
            IntTag intTag = (IntTag)nbt;
            n = intTag.m_7047_();
        } else {
            n = 0;
        }
        this.count = n;
    }

    @Override
    public Optional<JsonElement> writeJson() {
        return Optional.of(new JsonPrimitive((Number)this.count));
    }

    @Override
    public void readJson(JsonElement json) {
        int n;
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            n = jsonPrimitive.getAsInt();
        } else {
            n = 0;
        }
        this.count = n;
    }

    public static class Config
    extends IProgressCounter.Config<Integer> {
        public Config() {
            super(SimpleIntProgressCounter.TYPE);
        }

        @Override
        public Optional<Tag> writeNbt() {
            return Optional.of(StringTag.m_129297_((String)SimpleIntProgressCounter.TYPE));
        }

        @Override
        public IProgressCounter<Integer> initCounter() {
            return new SimpleIntProgressCounter();
        }
    }
}

