/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.util.IProgressCounter;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class SlidingTimeIntProgressCounter
implements IProgressCounter<Integer> {
    public static final String TYPE = "sliding_time";
    private List<Action> actions = new ArrayList<Action>();
    private int totalCount;
    private final int limitTicks;

    public SlidingTimeIntProgressCounter(Config config) {
        this.limitTicks = config.getLimitTicks();
    }

    @Override
    public void addCount(Integer count) {
        this.actions.add(new Action(0, count));
        this.updateTotalCount();
    }

    @Override
    public Integer getCount() {
        return this.totalCount;
    }

    @Override
    public void setCount(Integer count) {
        if (count == 0) {
            this.actions.clear();
        } else {
            if (count < this.totalCount) {
                throw new UnsupportedOperationException("Cannot set count to value lower than total count other than 0");
            }
            this.actions.add(new Action(0, count - this.totalCount));
        }
    }

    @Override
    public void onTick() {
        if (this.actions.isEmpty()) {
            return;
        }
        Iterator<Action> it = this.actions.iterator();
        boolean updateTotal = false;
        while (it.hasNext()) {
            Action action = it.next();
            action.incrementTickTime();
            if (action.tickTime() <= this.limitTicks) continue;
            it.remove();
            updateTotal = true;
        }
        if (updateTotal) {
            this.updateTotalCount();
        }
    }

    private void updateTotalCount() {
        this.totalCount = this.actions.stream().mapToInt(Action::count).sum();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        buffer.writeCollection(this.actions, Action::writeBits);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.actions = buffer.readCollection(ArrayList::new, Action::fromBits);
        this.updateTotalCount();
    }

    @Override
    public Optional<Tag> writeNbt() {
        CompoundTag tag = new CompoundTag();
        NBTHelper.writeCollection(tag, "actions", this.actions, CompoundTag.class, Action::writeNbt);
        return Optional.of(tag);
    }

    @Override
    public void readNbt(Tag nbt) {
        if (!(nbt instanceof CompoundTag)) {
            return;
        }
        CompoundTag compoundTag = (CompoundTag)nbt;
        this.actions = NBTHelper.readCollection(compoundTag, "actions", CompoundTag.class, Action::fromNbt, new ArrayList());
        this.updateTotalCount();
    }

    @Override
    public Optional<JsonElement> writeJson() {
        JsonObject json = new JsonObject();
        JsonArray actions = new JsonArray();
        this.actions.forEach(action -> action.writeJson().ifPresent(arg_0 -> ((JsonArray)actions).add(arg_0)));
        json.add("actions", (JsonElement)actions);
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonElement json) {
        if (!(json instanceof JsonObject)) {
            return;
        }
        JsonObject jsonObject = (JsonObject)json;
        this.actions.clear();
        jsonObject.getAsJsonArray("actions").forEach(jsonElement -> this.actions.add(Action.fromJson(jsonElement.getAsJsonObject())));
        this.updateTotalCount();
    }

    public int getLimitTicks() {
        return this.limitTicks;
    }

    public static class Config
    extends IProgressCounter.Config<Integer> {
        private int limitTicks;

        public Config() {
            super(SlidingTimeIntProgressCounter.TYPE);
        }

        public Config(int limitTicks) {
            super(SlidingTimeIntProgressCounter.TYPE);
            this.limitTicks = limitTicks;
        }

        public int getLimitTicks() {
            return this.limitTicks;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            buffer.writeInt(this.limitTicks);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.limitTicks = buffer.readInt();
        }

        @Override
        public Optional<Tag> writeNbt() {
            return super.writeNbt().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).map(nbt -> {
                nbt.m_128405_("limitTicks", this.limitTicks);
                return nbt;
            });
        }

        @Override
        public void readNbt(Tag nbt) {
            int n;
            super.readNbt(nbt);
            if (nbt instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)nbt;
                n = compoundTag.m_128451_("limitTicks");
            } else {
                n = 0;
            }
            this.limitTicks = n;
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                json.addProperty("limitTicks", (Number)this.limitTicks);
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.limitTicks = json.get("limitTicks").getAsInt();
        }

        @Override
        public IProgressCounter<Integer> initCounter() {
            return new SlidingTimeIntProgressCounter(this);
        }
    }

    private static final class Action {
        private int tickTime;
        private final int count;

        private Action(int tickTime, int count) {
            this.tickTime = tickTime;
            this.count = count;
        }

        public void incrementTickTime() {
            ++this.tickTime;
        }

        public int tickTime() {
            return this.tickTime;
        }

        public int count() {
            return this.count;
        }

        public void writeBits(BitBuffer buffer) {
            buffer.writeInt(this.tickTime);
            buffer.writeInt(this.count);
        }

        public static Action fromBits(BitBuffer buffer) {
            return new Action(buffer.readInt(), buffer.readInt());
        }

        public CompoundTag writeNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("tickTime", this.tickTime);
            tag.m_128405_("count", this.count);
            return tag;
        }

        public static Action fromNbt(CompoundTag nbt) {
            return new Action(nbt.m_128451_("tickTime"), nbt.m_128451_("count"));
        }

        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            json.addProperty("tickTime", (Number)this.tickTime);
            json.addProperty("count", (Number)this.count);
            return Optional.of(json);
        }

        public static Action fromJson(JsonObject json) {
            return new Action(json.get("tickTime").getAsInt(), json.get("count").getAsInt());
        }
    }
}

