/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.InventoryUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class CoinDefinition {
    public static Map<Item, CoinDefinition> COIN_DEFINITIONS;
    public final Item coinItem;
    @Nullable
    public final Item previousHigherDenomination;
    @Nullable
    public final Item nextLowerDenomination;
    public final int coinValue;

    public CoinDefinition(Item coinItem, @Nullable Item nextLowerDenomination, @Nullable Item previousHigherDenomination, int coinValue) {
        this.coinItem = coinItem;
        this.previousHigherDenomination = previousHigherDenomination;
        this.nextLowerDenomination = nextLowerDenomination;
        this.coinValue = coinValue;
    }

    public static int payUsingHigherDenominations(List<InventoryUtil.ItemAccess> allItems, int priceValue, CoinDefinition coinDefinition) {
        while (priceValue > 0 && coinDefinition.previousHigherDenomination != null) {
            coinDefinition = COIN_DEFINITIONS.get(coinDefinition.previousHigherDenomination);
            priceValue = CoinDefinition.deductCoins(allItems, priceValue, coinDefinition);
        }
        return priceValue;
    }

    public static int payUsingLowerDenominations(List<InventoryUtil.ItemAccess> allItems, int priceValue, CoinDefinition coinDefinition) {
        while (priceValue > 0 && coinDefinition.nextLowerDenomination != null) {
            coinDefinition = COIN_DEFINITIONS.get(coinDefinition.nextLowerDenomination);
            priceValue = CoinDefinition.deductCoins(allItems, priceValue, coinDefinition);
        }
        return priceValue;
    }

    public static int deductCoins(List<InventoryUtil.ItemAccess> allItems, int priceValue, CoinDefinition coinDefinition) {
        for (InventoryUtil.ItemAccess itemAccess : allItems) {
            ItemStack stack;
            int countToRemove;
            if (itemAccess.getItem() != coinDefinition.coinItem || (countToRemove = (int)Math.ceil((double)Math.min(priceValue, (stack = itemAccess.getStack()).m_41613_() * coinDefinition.coinValue) / (double)coinDefinition.coinValue)) <= 0) continue;
            itemAccess.setStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - countToRemove)));
            if ((priceValue -= countToRemove * coinDefinition.coinValue) > 0) continue;
            break;
        }
        return priceValue;
    }

    public static Optional<CoinDefinition> getCoinDefinition(Item coin) {
        if (COIN_DEFINITIONS == null) {
            COIN_DEFINITIONS = new LinkedHashMap<Item, CoinDefinition>();
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_BRONZE, new CoinDefinition((Item)ModBlocks.VAULT_BRONZE, (Item)ModBlocks.VAULT_SILVER, null, 1));
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_SILVER, new CoinDefinition((Item)ModBlocks.VAULT_SILVER, (Item)ModBlocks.VAULT_GOLD, (Item)ModBlocks.VAULT_BRONZE, 9));
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_GOLD, new CoinDefinition((Item)ModBlocks.VAULT_GOLD, (Item)ModBlocks.VAULT_PLATINUM, (Item)ModBlocks.VAULT_SILVER, 81));
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_PLATINUM, new CoinDefinition((Item)ModBlocks.VAULT_PLATINUM, null, (Item)ModBlocks.VAULT_GOLD, 729));
        }
        return Optional.ofNullable(COIN_DEFINITIONS.get(coin));
    }

    public static boolean hasEnoughCurrency(List<InventoryUtil.ItemAccess> allItems, ItemStack currency) {
        return CoinDefinition.getCoinDefinition(currency.m_41720_()).map(priceCoinDefinition -> {
            int requiredCount = currency.m_41613_();
            int availableCount = 0;
            Item requestedCoin = currency.m_41720_();
            for (InventoryUtil.ItemAccess itemAccess : allItems) {
                try {
                    if (itemAccess.getItem() == requestedCoin) {
                        availableCount += itemAccess.getStack().m_41613_();
                    }
                    if (availableCount < requiredCount) continue;
                    return true;
                }
                catch (Exception e) {
                    VaultMod.LOGGER.error("Error while checking currency availability", (Throwable)e);
                }
            }
            return availableCount >= requiredCount;
        }).orElse(false);
    }

    public static boolean extractCurrency(Player player, List<InventoryUtil.ItemAccess> allItems, ItemStack price) {
        CoinDefinition.getCoinDefinition(price.m_41720_()).ifPresent(priceCoinDefinition -> {
            int priceValue = priceCoinDefinition.coinValue * price.m_41613_();
            if ((priceValue = CoinDefinition.deductCoins(allItems, priceValue, priceCoinDefinition)) > 0) {
                priceValue = CoinDefinition.payUsingLowerDenominations(allItems, priceValue, priceCoinDefinition);
                priceValue = CoinDefinition.payUsingHigherDenominations(allItems, priceValue, priceCoinDefinition);
            }
            if (priceValue < 0) {
                int change = -priceValue;
                CoinDefinition.returnChangeToPlayer(player, change);
            }
        });
        return true;
    }

    private static void returnChangeToPlayer(Player player, int change) {
        while (change > 0) {
            for (CoinDefinition definition : COIN_DEFINITIONS.values()) {
                if (definition.coinValue > change || change / definition.coinValue >= 9) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)definition.coinItem, change / definition.coinValue));
                change -= definition.coinValue * (change / definition.coinValue);
            }
        }
    }
}

