/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.serializable.IJsonSerializable;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class ColorOption
implements IJsonSerializable<JsonElement> {
    HunterSpec hunterSpec;
    float red;
    float green;
    float blue;
    private static final EnumAdapter<HunterSpec> HUNTER_SPEC_ADAPTER = Adapters.ofEnum(HunterSpec.class, EnumAdapter.Mode.NAME);
    public static final Adapter ADAPTER = new Adapter();

    public ColorOption(HunterSpec objective, float red, float green, float blue) {
        this.hunterSpec = objective;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ColorOption(String hunterSpec, float red, float green, float blue) {
        this(HunterSpec.valueOf(hunterSpec), red, green, blue);
    }

    public ColorOption() {
    }

    public Color getColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public HunterSpec getHunterSpec() {
        return this.hunterSpec;
    }

    public void setHunterSpec(HunterSpec hunterSpec) {
        this.hunterSpec = hunterSpec;
    }

    public float getRed() {
        return this.red;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public float getGreen() {
        return this.green;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public float getBlue() {
        return this.blue;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    @Override
    public Optional<JsonElement> writeJson() {
        JsonObject json = new JsonObject();
        HUNTER_SPEC_ADAPTER.writeJson(this.hunterSpec).ifPresent(spec -> json.add("hunterSpec", spec));
        json.addProperty("red", (Number)Float.valueOf(this.red));
        json.addProperty("green", (Number)Float.valueOf(this.green));
        json.addProperty("blue", (Number)Float.valueOf(this.blue));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonElement element) {
        if (!(element instanceof JsonObject)) {
            throw new IllegalArgumentException("Invalid element type: " + element.getClass().getName());
        }
        JsonObject json = (JsonObject)element;
        this.hunterSpec = HUNTER_SPEC_ADAPTER.readJson(json.get("hunterSpec")).orElse(null);
        this.red = json.get("red").getAsFloat();
        this.green = json.get("green").getAsFloat();
        this.blue = json.get("blue").getAsFloat();
    }

    public static enum HunterSpec {
        WOODEN,
        OBSERVER,
        GILDED,
        LIVING,
        ORNATE,
        COINS;


        public String toString() {
            return "hunter_" + this.name().toLowerCase();
        }
    }

    public static class Adapter
    implements ISimpleAdapter<ColorOption, CompoundTag, JsonElement> {
        @Override
        public Optional<JsonElement> writeJson(@Nullable ColorOption value, Object context) {
            if (value == null) {
                return Optional.empty();
            }
            return value.writeJson();
        }

        @Override
        public Optional<ColorOption> readJson(@Nullable JsonElement json, Object context) {
            if (json == null) {
                return Optional.empty();
            }
            ColorOption option = new ColorOption();
            option.readJson(json);
            return Optional.of(option);
        }
    }
}

