/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.StringRepresentable;

public enum CooldownGuiOption implements StringRepresentable
{
    OFF(0),
    ON(1);

    private final int id;
    private static final Map<String, CooldownGuiOption> NAME_TO_TYPE;
    private static final CooldownGuiOption[] BY_ID;

    private CooldownGuiOption(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static CooldownGuiOption byId(int pId) {
        return BY_ID[pId % BY_ID.length];
    }

    public static CooldownGuiOption fromString(String name) {
        return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
    }

    public CooldownGuiOption cycle() {
        if (this.getId() + 1 >= BY_ID.length) {
            return CooldownGuiOption.byId(0);
        }
        return CooldownGuiOption.byId(this.getId() + 1);
    }

    @Nonnull
    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Nonnull
    public String getSerializedNameUpper() {
        return this.name().toUpperCase(Locale.ROOT);
    }

    static {
        NAME_TO_TYPE = Arrays.stream(CooldownGuiOption.values()).collect(Collectors.toMap(CooldownGuiOption::m_7912_, Functions.identity()));
        BY_ID = (CooldownGuiOption[])Arrays.stream(CooldownGuiOption.values()).sorted(Comparator.comparingInt(CooldownGuiOption::getId)).toArray(CooldownGuiOption[]::new);
    }
}

