/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import iskallia.vault.block.entity.VaultEnchanterTileEntity;
import iskallia.vault.container.VaultEnchanterContainer;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.SerializableAdapter;
import iskallia.vault.core.data.serializable.IJsonSerializable;
import iskallia.vault.util.InventoryUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class EnchantmentCost
implements IJsonSerializable<JsonObject> {
    public static EnchantmentCost EMPTY = new EnchantmentCost(new ArrayList<ItemStack>(), 0);
    private List<ItemStack> items = new LinkedList<ItemStack>();
    private int levels;
    public static SerializableAdapter<EnchantmentCost, CompoundTag, JsonObject> ADAPTER = new SerializableAdapter(EnchantmentCost::new, false);

    private EnchantmentCost() {
    }

    public EnchantmentCost(List<ItemStack> items, int levels) {
        this.items = items;
        this.levels = levels;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public int getLevels() {
        return this.levels;
    }

    public boolean tryConsume(ServerPlayer player) {
        if (player.m_7500_()) {
            return true;
        }
        if (player.f_36078_ < this.levels) {
            return false;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof VaultEnchanterContainer) {
            VaultEnchanterContainer container = (VaultEnchanterContainer)abstractContainerMenu;
            VaultEnchanterTileEntity tileEntity = container.getTileEntity();
            List<ItemStack> missing = InventoryUtil.getMissingInputs(this.items, player.m_150109_(), tileEntity.getEmeraldInventory());
            if (!missing.isEmpty()) {
                return false;
            }
            if (!InventoryUtil.consumeInputs(this.items, player.m_150109_(), tileEntity.getEmeraldInventory(), true)) {
                return false;
            }
            InventoryUtil.consumeInputs(this.items, player.m_150109_(), tileEntity.getEmeraldInventory(), false);
            player.m_9174_(player.f_36078_ - this.levels);
            return true;
        }
        List<ItemStack> missing = InventoryUtil.getMissingInputs(this.items, player.m_150109_());
        if (!missing.isEmpty()) {
            return false;
        }
        if (!InventoryUtil.consumeInputs(this.items, player.m_150109_(), true)) {
            return false;
        }
        InventoryUtil.consumeInputs(this.items, player.m_150109_(), false);
        player.m_9174_(player.f_36078_ - this.levels);
        return true;
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        JsonArray array = new JsonArray();
        this.items.forEach(stack -> Adapters.ITEM_STACK.writeJson((ItemStack)stack).ifPresent(arg_0 -> ((JsonArray)array).add(arg_0)));
        json.add("items", (JsonElement)array);
        json.add("levels", (JsonElement)new JsonPrimitive((Number)this.levels));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.items.clear();
        JsonArray array = json.getAsJsonArray("items");
        array.forEach(element -> Adapters.ITEM_STACK.readJson((JsonElement)element).ifPresent(this.items::add));
        this.levels = Adapters.INT.readJson(json.get("levels")).orElse(0);
    }
}

