/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.IByteSerializable;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.EnchantmentCost;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EnchantmentEntry
implements IByteSerializable {
    private Enchantment enchantment;
    private int level;

    public EnchantmentEntry(Enchantment enchantment, int level) {
        this.enchantment = enchantment;
        this.level = level;
    }

    public EnchantmentEntry(ByteBuf buffer) {
        this.readBytes(buffer);
    }

    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isValid() {
        return this.enchantment != null && this.level > 0 && this.level <= this.enchantment.m_6586_();
    }

    public void apply(ItemStack stack) {
        if (!this.enchantment.m_6081_(stack)) {
            return;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        enchantments.keySet().removeIf(other -> !this.enchantment.m_44695_(other));
        enchantments.put(this.enchantment, this.level);
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)stack);
    }

    public EnchantmentCost getCost() {
        return ModConfigs.VAULT_GEAR_ENCHANTMENT_CONFIG.getCost(this);
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        Adapters.ENCHANTMENT.writeBytes(this.enchantment, buffer);
        Adapters.INT_SEGMENTED_7.writeBytes(this.level, buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        this.enchantment = Adapters.ENCHANTMENT.readBytes(buffer).orElse(null);
        this.level = (Integer)Adapters.INT_SEGMENTED_7.readBytes(buffer).orElseThrow();
    }
}

