/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.google.common.collect.ImmutableSet;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.entity.PetEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class EntityReflectTracker {
    private static final Object lock = new Object();
    private static final Map<ResourceKey<Level>, Map<UUID, ReflectEntry>> entries = new HashMap<ResourceKey<Level>, Map<UUID, ReflectEntry>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onHurt(LivingHurtEvent event) {
        Entity dmgSource;
        LivingEntity hurt = event.getEntityLiving();
        if (hurt instanceof Player || hurt instanceof EternalEntity || hurt instanceof PetEntity || hurt.m_20147_()) {
            return;
        }
        UUID id = hurt.m_142081_();
        ResourceKey dimId = hurt.m_183503_().m_46472_();
        ReflectEntry entry = new ReflectEntry(id);
        Object object = lock;
        synchronized (object) {
            Map dimEntries = entries.computeIfAbsent((ResourceKey<Level>)dimId, k -> new HashMap());
            if (dimEntries.containsKey(id)) {
                ReflectEntry existing = (ReflectEntry)dimEntries.get(id);
                existing.onHit();
                entry = existing;
            } else {
                dimEntries.put(id, entry);
            }
        }
        if (entry.hitCount >= 2 && (dmgSource = event.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)dmgSource;
            float dmgDealt = event.getAmount();
            player.m_6469_(DamageSource.m_19335_((Entity)hurt), dmgDealt * 0.5f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.f_19797_ % 10 != 0) {
            return;
        }
        if (entity instanceof EternalEntity) return;
        if (!(entity instanceof Mob)) return;
        Mob mob = (Mob)entity;
        if (entity instanceof PetEntity) {
            return;
        }
        UUID id = entity.m_142081_();
        ResourceKey dimId = entity.m_183503_().m_46472_();
        Object object = lock;
        // MONITORENTER : object
        ReflectEntry entry = (ReflectEntry)entries.getOrDefault(dimId, Collections.emptyMap()).get(id);
        // MONITOREXIT : object
        if (entry == null) {
            return;
        }
        LivingEntity lastAttacker = entity.m_142581_();
        if (lastAttacker instanceof Player) {
            Player player = (Player)lastAttacker;
            if (!EntityReflectTracker.canCreatePath(mob, lastAttacker.m_142538_())) {
                float followRange = (float)mob.m_21133_(Attributes.f_22277_);
                int pathTrackingRange = (int)(followRange + 8.0f);
                if (entity.m_20280_((Entity)player) < (double)(pathTrackingRange * pathTrackingRange)) {
                    entity.m_6703_((LivingEntity)player);
                }
                entry.resetTimeout();
                return;
            }
        }
        entry.tickTimeout = Math.min(entry.tickTimeout, 10);
    }

    private static boolean canCreatePath(Mob mob, BlockPos target) {
        PathNavigation nav = mob.m_21573_();
        float followRange = (float)mob.m_21133_(Attributes.f_22277_);
        BlockPos mobPos = mob.m_142538_();
        int range = (int)(followRange + 8.0f);
        PathNavigationRegion region = new PathNavigationRegion(mob.m_183503_(), mobPos.m_142082_(-range, -range, -range), mobPos.m_142082_(range, range, range));
        Path path = nav.f_26512_.m_77427_(region, mob, (Set)ImmutableSet.of((Object)target), followRange, 0, 1.0f);
        return path != null && path.m_77403_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv == null) {
            entries.clear();
            return;
        }
        Object object = lock;
        synchronized (object) {
            entries.entrySet().removeIf(e -> {
                Map reflectEntries = (Map)e.getValue();
                ServerLevel lvl = srv.m_129880_((ResourceKey)e.getKey());
                if (lvl == null) {
                    return true;
                }
                reflectEntries.forEach((eId, reflectEntry) -> --reflectEntry.tickTimeout);
                reflectEntries.entrySet().removeIf(entry -> ((ReflectEntry)entry.getValue()).tickTimeout <= 0);
                reflectEntries.entrySet().removeIf(entry -> {
                    Entity entity = lvl.m_8791_((UUID)entry.getKey());
                    return entity == null || !entity.m_6084_() || entity.m_146910_();
                });
                return reflectEntries.isEmpty();
            });
        }
    }

    public static class ReflectEntry {
        private final UUID entityId;
        private int hitCount = 0;
        private int tickTimeout;

        public ReflectEntry(UUID entityId) {
            this.entityId = entityId;
            this.resetTimeout();
        }

        public void resetTimeout() {
            this.tickTimeout = 300;
        }

        public void onHit() {
            ++this.hitCount;
            this.resetTimeout();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReflectEntry that = (ReflectEntry)o;
            return Objects.equals(this.entityId, that.entityId);
        }

        public int hashCode() {
            return Objects.hash(this.entityId);
        }
    }
}

