/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class Entropy {
    private static final Entropy INSTANCE = new Entropy();
    private static final Random rand = new Random();
    private final Map<UUID, Map<Stat, Float>> playerStatMap = new HashMap<UUID, Map<Stat, Float>>();

    private Entropy() {
    }

    private synchronized Map<Stat, Float> getEntropyStats(UUID uuid) {
        return this.playerStatMap.computeIfAbsent(uuid, id -> new HashMap());
    }

    public static boolean canExecute(Entity entity, Stat stat, float chance) {
        boolean randomHit;
        if (chance >= 1.0f) {
            return true;
        }
        if (chance <= 0.0f) {
            return false;
        }
        boolean bl = randomHit = rand.nextFloat() < chance;
        if (!(entity instanceof Player)) {
            return randomHit;
        }
        UUID playerId = entity.m_142081_();
        Map<Stat, Float> entropyStats = INSTANCE.getEntropyStats(playerId);
        float entropy = entropyStats.computeIfAbsent(stat, s -> Float.valueOf(0.0f)).floatValue();
        if (randomHit) {
            entropyStats.put(stat, Float.valueOf(entropy -= 1.0f));
            return true;
        }
        if ((entropy += chance) >= 1.0f) {
            entropyStats.put(stat, Float.valueOf(Math.max(entropy -= 1.0f, -2.0f)));
            return true;
        }
        entropyStats.put(stat, Float.valueOf(entropy));
        return false;
    }

    public static class Stat {
        public static final Stat BLOCK = new Stat(0);
        public static final Stat THORNS = new Stat(1);
        public static final Stat FATAL_STRIKE = new Stat(2);
        public static final Stat VANILLA_CRITICAL = new Stat(3);
        public static final Stat STUN_ATTACK_CHANCE = new Stat(4);
        public static final Stat KNOCKBACK_ATTACK_CHANCE = new Stat(5);
        public static final Stat DOUBLE_ATTACK = new Stat(6);
        private final int hash;

        private Stat(int hash) {
            this.hash = hash;
        }

        public static Stat effectCloud(MobEffect effect) {
            return new Stat(effect.getRegistryName().hashCode());
        }

        public static Stat effectCloudWhenHit(MobEffect effect) {
            return new Stat(31 * effect.getRegistryName().hashCode());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stat stat = (Stat)o;
            return this.hash == stat.hash;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

