/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.VaultMod;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.entity.PartialEntity;
import iskallia.vault.core.world.data.entity.PartialEntityGroup;
import iskallia.vault.core.world.data.tile.PartialBlockGroup;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GroupUtils {
    public static final HashMap<EntityPredicate, Set<EntityType<?>>> ENTITY_GROUPS = new HashMap();
    public static final HashMap<ResourceLocation, Set<ResourceLocation>> BLOCK_GROUPS = new HashMap();
    private static boolean isSetup = false;

    @SubscribeEvent
    public static void setup(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (isSetup) {
            return;
        }
        GroupUtils.loadBlockGroups();
        GroupUtils.loadEntityGroups();
        isSetup = true;
    }

    private static void loadEntityGroups() {
        VaultMod.LOGGER.info("Loading Entity Groups Started");
        long start = System.currentTimeMillis();
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        List<Entity> entities = GroupUtils.createAllEntities(level);
        Map<ResourceLocation, EntityPredicate> groups = ModConfigs.ENTITY_GROUPS.getGroups();
        for (ResourceLocation group : groups.keySet()) {
            HashSet<EntityType> types = new HashSet<EntityType>();
            for (Entity entity : entities) {
                if (!ModConfigs.ENTITY_GROUPS.isInGroup(group, entity)) continue;
                types.add(entity.m_6095_());
            }
            ENTITY_GROUPS.put(PartialEntityGroup.of(group, PartialCompoundNbt.empty()), types);
        }
        VaultMod.LOGGER.info("Loading Entity Groups Completed in {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private static void loadBlockGroups() {
        VaultMod.LOGGER.info("Loading Block Groups Started");
        long start = System.currentTimeMillis();
        Map<ResourceLocation, Set<TilePredicate>> groups = ModConfigs.TILE_GROUPS.getGroups();
        Collection allBlocks = ForgeRegistries.BLOCKS.getValues();
        for (ResourceLocation group : groups.keySet()) {
            HashSet<ResourceLocation> blockIds = new HashSet<ResourceLocation>();
            for (Block block : allBlocks) {
                ResourceLocation key;
                if (!ModConfigs.TILE_GROUPS.isInGroup(group, PartialTile.of(PartialBlockState.of(block), PartialCompoundNbt.empty())) || (key = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)) == null) continue;
                blockIds.add(key);
            }
            BLOCK_GROUPS.put(group, blockIds);
        }
        VaultMod.LOGGER.info("Loading Block Groups Completed in {}ms", (Object)(System.currentTimeMillis() - start));
    }

    public static Set<ResourceLocation> getBlockIdsFor(TilePredicate predicate) {
        if (predicate instanceof PartialBlockGroup) {
            PartialBlockGroup tilePredicate = (PartialBlockGroup)predicate;
            ResourceLocation id = tilePredicate.getId();
            return BLOCK_GROUPS.getOrDefault(id, new HashSet());
        }
        return new HashSet<ResourceLocation>();
    }

    private static List<Entity> createAllEntities(ClientLevel level) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Collection entityTypes = ForgeRegistries.ENTITIES.getValues();
        for (EntityType entityType : entityTypes) {
            Entity entity = entityType.m_20615_((Level)level);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            entities.add((Entity)living);
        }
        return entities;
    }

    public static Set<String> getEntityNamesAsString(EntityPredicate filter) {
        PartialEntity partialEntity;
        Optional<CompoundTag> whole;
        if (filter instanceof PartialEntity && (whole = (partialEntity = (PartialEntity)filter).getNbt().asWhole()).isPresent()) {
            String id = whole.get().m_128461_("id");
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            return type == null ? Set.of() : Set.of(type.m_20676_().getString());
        }
        return ENTITY_GROUPS.getOrDefault(filter, Set.of()).stream().map(entityType -> entityType.m_20676_().getString()).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Component getEntityName(EntityPredicate filter) {
        PartialEntity entity;
        Optional<CompoundTag> whole;
        if (filter instanceof PartialEntityGroup) {
            PartialEntityGroup group = (PartialEntityGroup)filter;
            if (group.getId().m_135815_().equalsIgnoreCase("fighter")) {
                return new TextComponent("Dweller");
            }
            return TextUtil.formatLocationPathAsProperNoun(group.getId());
        }
        if (filter instanceof PartialEntity && (whole = (entity = (PartialEntity)filter).getNbt().asWhole()).isPresent()) {
            String id = whole.get().m_128461_("id");
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
            return type == null ? Component.m_130674_((String)"Entities") : type.m_20676_();
        }
        return Component.m_130674_((String)"");
    }

    public static List<String> getEntityGroupNames() {
        return ENTITY_GROUPS.keySet().stream().map(GroupUtils::getEntityName).map(Component::getString).sorted().toList();
    }

    public static Optional<EntityPredicate> getFilterByName(String groupName) {
        groupName = groupName.toLowerCase().replace(' ', '_');
        ResourceLocation groupId = VaultMod.id(groupName.toLowerCase());
        if (groupName.equalsIgnoreCase("dweller")) {
            groupId = VaultMod.id("fighter");
        }
        for (EntityPredicate predicate : ENTITY_GROUPS.keySet()) {
            PartialEntityGroup group;
            if (!(predicate instanceof PartialEntityGroup) || !groupId.equals((Object)(group = (PartialEntityGroup)predicate).getId())) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    public static Optional<EntityPredicate> getFilterById(ResourceLocation groupId) {
        for (EntityPredicate predicate : ENTITY_GROUPS.keySet()) {
            PartialEntityGroup group;
            if (!(predicate instanceof PartialEntityGroup) || !groupId.equals((Object)(group = (PartialEntityGroup)predicate).getId())) continue;
            return Optional.of(predicate);
        }
        return Optional.empty();
    }

    public static List<EntityType<?>> getEntityTypes(ResourceLocation groupId) {
        Set types = ENTITY_GROUPS.getOrDefault(PartialEntityGroup.of(groupId, PartialCompoundNbt.empty()), Set.of());
        Comparator entityTypeComparator = (o1, o2) -> {
            Comparator<String> stringComparator = Comparator.naturalOrder();
            return stringComparator.compare(o1.m_20676_().getString(), o2.m_20676_().getString());
        };
        return types.stream().sorted(entityTypeComparator).toList();
    }
}

