/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.DropdownElement;
import iskallia.vault.client.gui.framework.element.NineSliceButtonElement;
import iskallia.vault.client.gui.framework.element.ToggleButtonElement;
import iskallia.vault.client.gui.framework.element.spi.ILayoutStrategy;
import iskallia.vault.client.gui.framework.element.spi.ITooltipElement;
import iskallia.vault.client.gui.framework.render.TooltipDirection;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRenderer;
import iskallia.vault.client.gui.framework.screen.AbstractElementScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.framework.text.LabelTextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiHelper {
    public static final int DEFAULT_WIDGET_WIDTH = 150;
    public static final int DEFAULT_WIDGET_HEIGHT = 20;
    public static final int DEFAULT_PADDING = 4;
    public static final int DEFAULT_ICON_SIZE = 16;
    public static final int ICON_TEXT_SPACING = 4;
    private final AbstractElementScreen screen;

    public GuiHelper(AbstractElementScreen screen) {
        this.screen = screen;
    }

    public ToggleButtonElement createToggleButton(int x, int y, String label, Supplier<String> valueGetter, Runnable onClick) {
        return this.createToggleButton(x, y, 150, 20, label, valueGetter, onClick, null, null, null, null);
    }

    public ToggleButtonElement createToggleButton(int x, int y, int width, int height, String label, Supplier<String> valueGetter, Runnable onClick) {
        return this.createToggleButton(x, y, width, height, label, valueGetter, onClick, null, null, null, null);
    }

    public ToggleButtonElement createToggleButton(int x, int y, String label, Supplier<String> valueGetter, Runnable onClick, @Nullable List<Component> tooltip) {
        return this.createToggleButton(x, y, 150, 20, label, valueGetter, onClick, tooltip, null, null, null);
    }

    public ToggleButtonElement createToggleButton(int x, int y, String label, Supplier<String> valueGetter, Runnable onClick, @Nullable Supplier<Boolean> disabledCondition) {
        return this.createToggleButton(x, y, 150, 20, label, valueGetter, onClick, null, disabledCondition, null, null);
    }

    public ToggleButtonElement createToggleButton(int x, int y, String label, Supplier<String> valueGetter, Runnable onClick, @Nullable TextureAtlasRegion icon) {
        return this.createToggleButton(x, y, 150, 20, label, valueGetter, onClick, null, null, icon, null);
    }

    public ToggleButtonElement createToggleButton(int x, int y, int width, int height, String label, Supplier<String> valueGetter, Runnable onClick, @Nullable List<Component> tooltip, @Nullable Supplier<Boolean> disabledCondition, @Nullable TextureAtlasRegion icon, @Nullable ILayoutStrategy layoutStrategy) {
        ToggleButtonWithTooltip button = new ToggleButtonWithTooltip(Spatials.positionXY(x, y).size(width, height), (Component)new TextComponent(label), valueGetter, onClick, tooltip, icon);
        if (disabledCondition != null) {
            button.setDisabled(disabledCondition);
        }
        if (layoutStrategy != null) {
            button.layout(layoutStrategy);
        }
        return button;
    }

    public NineSliceButtonElement<?> createSimpleButton(int x, int y, String label, Runnable onClick, @Nullable List<Component> tooltip, @Nullable Supplier<Boolean> disabledCondition, @Nullable TextureAtlasRegion icon, @Nullable ILayoutStrategy layoutStrategy) {
        return this.createSimpleButton(x, y, 150, 20, label, onClick, tooltip, disabledCondition, icon, layoutStrategy);
    }

    public NineSliceButtonElement<?> createSimpleButton(int x, int y, int width, int height, String label, Runnable onClick, @Nullable List<Component> tooltip, @Nullable Supplier<Boolean> disabledCondition, @Nullable TextureAtlasRegion icon, @Nullable ILayoutStrategy layoutStrategy) {
        SimpleButtonWithTooltip button = new SimpleButtonWithTooltip(Spatials.positionXY(x, y).size(width, height), ScreenTextures.BUTTON_EMPTY_TEXTURES, onClick, (Component)new TextComponent(label), tooltip, icon);
        if (disabledCondition != null) {
            button.setDisabled(disabledCondition);
        }
        if (layoutStrategy != null) {
            button.layout(layoutStrategy);
        }
        return button;
    }

    private static class ToggleButtonWithTooltip
    extends ToggleButtonElement {
        private final List<Component> tooltip;
        private final TextureAtlasRegion icon;

        public ToggleButtonWithTooltip(ISpatial spatial, Component title, Supplier<String> append, Runnable onClick, @Nullable List<Component> tooltip, @Nullable TextureAtlasRegion icon) {
            super(spatial, title, append, onClick);
            this.tooltip = tooltip;
            this.icon = icon;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            if (this.icon != null && this.isVisible()) {
                int iconX = this.getWorldSpatial().x() + 4;
                int iconY = this.getWorldSpatial().y() + (this.getWorldSpatial().height() - 16) / 2;
                this.icon.blit(poseStack, iconX, iconY, this.getWorldSpatial().z() + 1, 16, 16);
            }
        }

        @Override
        protected void renderLabel(IElementRenderer renderer, PoseStack poseStack, int x, int y, int z, int width) {
            MutableComponent label = ((Component)this.component.get()).m_6881_().m_130946_(": ").m_130946_((String)this.append.get());
            this.labelTextStyle.textBorder().render(renderer, poseStack, (Component)label, this.labelTextStyle.textWrap(), this.labelTextStyle.textAlign(), x, y, z, width);
        }

        @Override
        public boolean renderTooltip(ITooltipRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY) {
            if (this.tooltip != null && !this.tooltip.isEmpty() && this.isVisible() && this.containsMouse(mouseX, mouseY)) {
                renderer.renderComponentTooltip(poseStack, this.tooltip, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            }
            return false;
        }
    }

    private static class SimpleButtonWithTooltip
    extends NineSliceButtonElement<SimpleButtonWithTooltip>
    implements ITooltipElement {
        private final List<Component> tooltip;
        private final TextureAtlasRegion icon;

        public SimpleButtonWithTooltip(ISpatial spatial, NineSliceButtonElement.NineSliceButtonTextures textures, Runnable onClick, Component label, @Nullable List<Component> tooltip, @Nullable TextureAtlasRegion icon) {
            super(spatial, textures, onClick);
            this.label(() -> label, LabelTextStyle.shadow().center());
            this.tooltip = tooltip;
            this.icon = icon;
        }

        @Override
        public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.render(renderer, poseStack, mouseX, mouseY, partialTick);
            if (this.icon != null && this.isVisible()) {
                int iconX = this.getWorldSpatial().x() + 4;
                int iconY = this.getWorldSpatial().y() + (this.getWorldSpatial().height() - 16) / 2;
                this.icon.blit(poseStack, iconX, iconY, this.getWorldSpatial().z() + 1, 16, 16);
            }
        }

        @Override
        protected void renderLabel(IElementRenderer renderer, PoseStack poseStack, int x, int y, int z, int width) {
            this.labelTextStyle.textBorder().render(renderer, poseStack, (Component)this.component.get(), this.labelTextStyle.textWrap(), this.labelTextStyle.textAlign(), x, y, z, width);
        }

        @Override
        public boolean renderTooltip(ITooltipRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY) {
            if (this.tooltip != null && !this.tooltip.isEmpty() && this.isVisible() && this.containsMouse(mouseX, mouseY)) {
                renderer.renderComponentTooltip(poseStack, this.tooltip, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            }
            return false;
        }
    }

    private static class DropdownWithTooltip
    extends DropdownElement<DropdownWithTooltip>
    implements ITooltipElement {
        private final List<Component> tooltip;

        public DropdownWithTooltip(ISpatial spatial, List<String> options, Consumer<String> onSelect, @Nullable List<Component> tooltip) {
            super(spatial, options, onSelect);
            this.tooltip = tooltip;
        }

        @Override
        public boolean renderTooltip(ITooltipRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY) {
            if (this.tooltip != null && !this.tooltip.isEmpty() && this.isVisible() && this.containsMouse(mouseX, mouseY)) {
                renderer.renderComponentTooltip(poseStack, this.tooltip, mouseX, mouseY, TooltipDirection.RIGHT);
                return true;
            }
            return false;
        }
    }

    public static class Tooltips {
        public static List<Component> create(String ... lines) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            for (String line : lines) {
                tooltip.add((Component)new TextComponent(line));
            }
            return tooltip;
        }

        public static List<Component> createTranslatable(String ... keys) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            for (String key : keys) {
                tooltip.add((Component)new TranslatableComponent(key));
            }
            return tooltip;
        }
    }

    public static class Layouts {
        public static ILayoutStrategy centeredHorizontally(int yOffset) {
            return (screen, gui, parent, world) -> world.translateXY(screen.width() / 2 - world.width() / 2, yOffset);
        }

        public static ILayoutStrategy centered() {
            return (screen, gui, parent, world) -> world.translateXY(screen.width() / 2 - world.width() / 2, screen.height() / 2 - world.height() / 2);
        }

        public static ILayoutStrategy centeredWithOffset(int xOffset, int yOffset) {
            return (screen, gui, parent, world) -> world.translateXY(screen.width() / 2 - world.width() / 2 + xOffset, yOffset);
        }
    }
}

