/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.block.VaultBarrelBlock;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.integration.IntegrationSB;
import iskallia.vault.item.BasicScavengerItem;
import iskallia.vault.item.BossRuneItem;
import iskallia.vault.item.CatalystInhibitorItem;
import iskallia.vault.item.CoinPouchItem;
import iskallia.vault.item.GodBlessingItem;
import iskallia.vault.item.ItemVaultKeyring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class InventoryUtil {
    private static final Set<Function<Player, List<ItemAccess>>> INVENTORY_ACCESS = Set.of(player -> {
        ArrayList<ItemAccess> items = new ArrayList<ItemAccess>();
        Inventory inv = player.m_150109_();
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (stack.m_41619_()) continue;
            int finalSlot = slot;
            items.add(new ItemAccess(stack, newStack -> inv.m_6836_(finalSlot, newStack)));
        }
        return items;
    }, player -> {
        ArrayList items = new ArrayList();
        IntegrationCurios.getCuriosItemStacks((LivingEntity)player).forEach((slot, stackTpl) -> stackTpl.forEach(tpl -> {
            ItemStack stack = (ItemStack)tpl.m_14418_();
            if (stack.m_41619_()) {
                return;
            }
            items.add(new ItemAccess(stack, newStack -> IntegrationCurios.setCurioItemStack((LivingEntity)player, newStack, slot, (Integer)tpl.m_14419_())));
        }));
        return items;
    });
    private static final Set<Function<Player, List<ItemAccess>>> MAIN_HAND_ACCESS = Set.of(player -> {
        ArrayList<ItemAccess> items = new ArrayList<ItemAccess>();
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_41619_()) {
            Inventory inv = player.m_150109_();
            items.add(new ItemAccess(mainHandItem, newStack -> inv.m_6836_(inv.f_35977_, newStack)));
        }
        return items;
    });
    private static final Set<Function<ItemAccess, List<ItemAccess>>> CONTENT_ACCESSORS = Set.of(IntegrationSB::getBackpackItemAccess, InventoryUtil::getShulkerBoxAccess, InventoryUtil::getBundleItemAccess, InventoryUtil::getSatchelItemAccess, InventoryUtil::getSupplementariesSafeAccess, InventoryUtil::getSupplementariesSackAccess, InventoryUtil::getBotaniaBaubleBoxAccess, InventoryUtil::getKeyringItemAccess, InventoryUtil::getCoinPouchItemAccess);

    public static List<ItemAccess> findAllItems(Player player) {
        ArrayList<ItemAccess> itemAccesses = new ArrayList<ItemAccess>(player.m_150109_().m_6643_());
        for (Function<Player, List<ItemAccess>> inventoryFn : INVENTORY_ACCESS) {
            inventoryFn.apply(player).forEach(inventoryStackAccess -> InventoryUtil.discoverContents(inventoryStackAccess, itemAccesses));
        }
        return itemAccesses;
    }

    public static List<ItemAccess> findAllItemsInMainHand(Player player) {
        ArrayList<ItemAccess> itemAccesses = new ArrayList<ItemAccess>(1);
        for (Function<Player, List<ItemAccess>> mainHandFn : MAIN_HAND_ACCESS) {
            mainHandFn.apply(player).forEach(mainHandStackAccess -> InventoryUtil.discoverContents(mainHandStackAccess, itemAccesses));
        }
        return itemAccesses;
    }

    public static boolean hasItem(Player player, Item item) {
        return InventoryUtil.matches(player, stack -> stack.m_150930_(item));
    }

    public static boolean matches(Player player, Predicate<ItemStack> predicate) {
        ArrayList<List<ItemAccess>> itemAccesses = new ArrayList<List<ItemAccess>>();
        for (Function<Player, List<ItemAccess>> accessor : INVENTORY_ACCESS) {
            List<ItemAccess> apply = accessor.apply(player);
            itemAccesses.add(apply);
        }
        return InventoryUtil.matchesUpper(itemAccesses, predicate);
    }

    private static boolean matchesUpper(List<List<ItemAccess>> itemAccesses, Predicate<ItemStack> predicate) {
        for (List<ItemAccess> itemAccessList : itemAccesses) {
            for (ItemAccess itemAccess : itemAccessList) {
                if (!predicate.test(itemAccess.getStack())) continue;
                return true;
            }
        }
        for (List<ItemAccess> itemAccessList : itemAccesses) {
            if (!InventoryUtil.matchesLower(itemAccessList, predicate)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesLower(List<ItemAccess> itemAccesses, Predicate<ItemStack> predicate) {
        ArrayList<List<ItemAccess>> contentAccesses = new ArrayList<List<ItemAccess>>();
        for (ItemAccess itemAccess : itemAccesses) {
            for (Function<ItemAccess, List<ItemAccess>> contentAccess : CONTENT_ACCESSORS) {
                contentAccesses.add(contentAccess.apply(itemAccess));
            }
        }
        return InventoryUtil.matchesUpper(contentAccesses, predicate);
    }

    public static void makeItemsRotten(Player player) {
        List<ItemAccess> itemAccess = InventoryUtil.findAllItems(player);
        for (ItemAccess items : itemAccess) {
            ItemStack stack = items.getStack();
            if (!(stack.m_41720_() instanceof BossRuneItem) && !(stack.m_41720_() instanceof BasicScavengerItem) && !(stack.m_41720_() instanceof GodBlessingItem) && !(stack.m_41720_() instanceof CatalystInhibitorItem)) continue;
            items.setter.accept(ItemStack.f_41583_);
        }
    }

    public static void makeItemsRotten(List<ItemStack> items) {
        Iterator<ItemStack> iterator = items.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!(stack.m_41720_() instanceof BossRuneItem) && !(stack.m_41720_() instanceof BasicScavengerItem) && !(stack.m_41720_() instanceof CatalystInhibitorItem) && !(stack.m_41720_() instanceof GodBlessingItem)) continue;
            stack.m_41764_(0);
            iterator.remove();
        }
    }

    public static void removeRoyaleItems(Player player) {
        List<ItemAccess> itemAccess = InventoryUtil.findAllItems(player);
        for (ItemAccess items : itemAccess) {
            ItemStack stack = items.getStack();
            if (!stack.m_41784_().m_128441_("VaultRoyaleLootable") || !stack.m_41784_().m_128471_("VaultRoyaleLootable")) continue;
            items.setter.accept(ItemStack.f_41583_);
        }
    }

    public static boolean isRoyaleItem(ItemStack stack) {
        return stack.m_41784_().m_128441_("VaultRoyaleLootable") && stack.m_41784_().m_128471_("VaultRoyaleLootable");
    }

    private static void discoverContents(ItemAccess access, List<ItemAccess> out) {
        InventoryUtil.discoverContents(access, out, new IdentityHashMap<ItemStack, Boolean>(), 0);
    }

    private static void discoverContents(ItemAccess access, List<ItemAccess> out, Map<ItemStack, Boolean> visited, int depth) {
        if (depth > 32) {
            return;
        }
        ItemStack stack = access.stack;
        if (stack == null || stack.m_41619_()) {
            return;
        }
        if (visited.put(stack, Boolean.TRUE) != null) {
            return;
        }
        out.add(access);
        for (Function<ItemAccess, List<ItemAccess>> containerAccess : CONTENT_ACCESSORS) {
            for (ItemAccess containedAccess : containerAccess.apply(access)) {
                InventoryUtil.discoverContents(containedAccess, out, visited, depth + 1);
            }
        }
    }

    public static List<ItemStack> findAllItems(List<ItemStack> items) {
        ArrayList<ItemAccess> itemAccesses = new ArrayList<ItemAccess>();
        for (ItemStack stack : items) {
            ItemAccess readOnlyStack = new ItemAccess(stack);
            itemAccesses.add(readOnlyStack);
            for (Function<ItemAccess, List<ItemAccess>> containerAccess : CONTENT_ACCESSORS) {
                containerAccess.apply(readOnlyStack).forEach(containedAccess -> InventoryUtil.discoverContents(containedAccess, itemAccesses));
            }
        }
        return itemAccesses.stream().map(ItemAccess::getStack).collect(Collectors.toList());
    }

    public static List<ItemStack> getMissingInputs(List<ItemStack> recipeInputs, Inventory playerInventory) {
        return InventoryUtil.getMissingInputs(recipeInputs, playerInventory, OverSizedInventory.EMPTY);
    }

    public static List<ItemStack> getMissingInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory containerInventory) {
        ArrayList<ItemStack> missing = new ArrayList<ItemStack>();
        for (ItemStack input : recipeInputs) {
            int neededCount = input.m_41613_();
            for (OverSizedItemStack overSized : containerInventory.getOverSizedContents()) {
                if (!InventoryUtil.isEqualCrafting(input, overSized.stack())) continue;
                neededCount -= overSized.amount();
            }
            if (neededCount > 0) {
                for (ItemAccess plStack : InventoryUtil.findAllItems(playerInventory.f_35978_)) {
                    if (!InventoryUtil.isEqualCrafting(input, plStack.stack) || (neededCount -= plStack.stack.m_41613_()) > 0) continue;
                    break;
                }
            }
            if (neededCount <= 0) continue;
            missing.add(input);
        }
        return missing;
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, boolean simulate) {
        return InventoryUtil.consumeInputs(recipeInputs, playerInventory, OverSizedInventory.EMPTY, simulate);
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory tileInv, boolean simulate) {
        return InventoryUtil.consumeInputs(recipeInputs, playerInventory, tileInv, simulate, new ArrayList<OverSizedItemStack>());
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, boolean simulate, List<OverSizedItemStack> consumed) {
        return InventoryUtil.consumeInputs(recipeInputs, playerInventory, OverSizedInventory.EMPTY, simulate, consumed);
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory tileInv, boolean simulate, List<OverSizedItemStack> consumed) {
        if (playerInventory.f_35978_.m_7500_()) {
            return true;
        }
        boolean success = true;
        for (ItemStack input : recipeInputs) {
            int neededCount = input.m_41613_();
            NonNullList<OverSizedItemStack> overSizedContents = tileInv.getOverSizedContents();
            for (int slot = 0; slot < overSizedContents.size(); ++slot) {
                OverSizedItemStack overSized = (OverSizedItemStack)overSizedContents.get(slot);
                if (neededCount <= 0) break;
                if (!InventoryUtil.isEqualCrafting(input, overSized.stack())) continue;
                int deductedAmount = Math.min(neededCount, overSized.amount());
                if (!simulate) {
                    tileInv.setOverSizedStack(slot, overSized.addCopy(-deductedAmount));
                    consumed.add(overSized.copyAmount(deductedAmount));
                }
                neededCount -= overSized.amount();
            }
            List<ItemAccess> items = InventoryUtil.findAllItems(playerInventory.f_35978_);
            for (ItemAccess plStack : items) {
                if (neededCount <= 0) break;
                if (!InventoryUtil.isEqualCrafting(input, plStack.stack)) continue;
                int deductedAmount = Math.min(neededCount, plStack.stack.m_41613_());
                if (!simulate) {
                    plStack.stack.m_41774_(deductedAmount);
                    plStack.setter.accept(plStack.stack);
                    ItemStack deducted = plStack.stack.m_41777_();
                    deducted.m_41764_(deductedAmount);
                    consumed.add(OverSizedItemStack.of(deducted));
                }
                neededCount -= deductedAmount;
            }
            if (neededCount <= 0) continue;
            success = false;
        }
        return success;
    }

    public static boolean isEqualCrafting(ItemStack thisStack, ItemStack thatStack) {
        return thisStack.m_41720_() == thatStack.m_41720_() && thisStack.m_41773_() == thatStack.m_41773_() && (thisStack.m_41783_() == null || thisStack.areShareTagsEqual(thatStack));
    }

    private static List<ItemAccess> getBotaniaBaubleBoxAccess(ItemAccess containerAccess) {
        if (InventoryUtil.doesntMatch(containerAccess, "botania:bauble_box")) {
            return Collections.emptyList();
        }
        ItemStack container = containerAccess.stack;
        if (!container.m_41782_()) {
            return Collections.emptyList();
        }
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        ListTag itemList = container.m_41784_().m_128437_("Items", 10);
        for (int slot = 0; slot < itemList.size(); ++slot) {
            ItemStack storedItem = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(slot));
            if (storedItem.m_41619_()) continue;
            int finalSlot = slot;
            accesses.add(containerAccess.chain(storedItem, (containerCt, newStack) -> {
                ListTag containerList = containerCt.m_41784_().m_128437_("Items", 10);
                CompoundTag newItemTag = new CompoundTag();
                newStack.m_41739_(newItemTag);
                containerList.set(finalSlot, (Tag)newItemTag);
                containerCt.m_41784_().m_128365_("Items", (Tag)containerList);
            }));
        }
        return accesses;
    }

    private static List<ItemAccess> getSupplementariesSackAccess(ItemAccess containerAccess) {
        if (InventoryUtil.doesntMatch(containerAccess, "supplementaries:sack")) {
            return Collections.emptyList();
        }
        ItemStack container = containerAccess.stack;
        if (!container.m_41782_()) {
            return Collections.emptyList();
        }
        CompoundTag tag = BlockItem.m_186336_((ItemStack)container);
        if (tag == null) {
            return Collections.emptyList();
        }
        NonNullList contents = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)contents);
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        for (int slot = 0; slot < contents.size(); ++slot) {
            ItemStack stack = (ItemStack)contents.get(slot);
            if (stack.m_41619_()) continue;
            int finalSlot = slot;
            accesses.add(containerAccess.chain(stack, (containerStack, newStack) -> {
                NonNullList ctContents = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
                CompoundTag ctTag = BlockItem.m_186336_((ItemStack)containerStack);
                if (ctTag != null) {
                    ContainerHelper.m_18980_((CompoundTag)ctTag, (NonNullList)ctContents);
                    ctContents.set(finalSlot, newStack);
                    ContainerHelper.m_18973_((CompoundTag)ctTag, (NonNullList)ctContents);
                    containerStack.m_41700_("BlockEntityTag", (Tag)ctTag);
                }
            }));
        }
        return accesses;
    }

    private static List<ItemAccess> getSupplementariesSafeAccess(ItemAccess containerAccess) {
        if (InventoryUtil.doesntMatch(containerAccess, "supplementaries:safe")) {
            return Collections.emptyList();
        }
        ItemStack container = containerAccess.stack;
        if (!container.m_41782_()) {
            return Collections.emptyList();
        }
        CompoundTag tag = BlockItem.m_186336_((ItemStack)container);
        if (tag == null) {
            return Collections.emptyList();
        }
        NonNullList contents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)contents);
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        for (int slot = 0; slot < contents.size(); ++slot) {
            ItemStack stack = (ItemStack)contents.get(slot);
            if (stack.m_41619_()) continue;
            int finalSlot = slot;
            accesses.add(containerAccess.chain(stack, (containerStack, newStack) -> {
                NonNullList ctContents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                CompoundTag ctTag = BlockItem.m_186336_((ItemStack)containerStack);
                if (ctTag != null) {
                    ContainerHelper.m_18980_((CompoundTag)ctTag, (NonNullList)ctContents);
                    ctContents.set(finalSlot, newStack);
                    ContainerHelper.m_18973_((CompoundTag)ctTag, (NonNullList)ctContents);
                    containerStack.m_41700_("BlockEntityTag", (Tag)ctTag);
                }
            }));
        }
        return accesses;
    }

    private static List<ItemAccess> getSatchelItemAccess(ItemAccess containerAccess) {
        if (InventoryUtil.doesntMatch(containerAccess, "thermal:satchel")) {
            return Collections.emptyList();
        }
        ItemStack container = containerAccess.stack;
        if (!container.m_41782_()) {
            return Collections.emptyList();
        }
        CompoundTag invTag = container.m_41698_("ItemInv");
        if (!invTag.m_128425_("ItemInv", 9)) {
            return Collections.emptyList();
        }
        ListTag list = invTag.m_128437_("ItemInv", 10);
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        for (int slot = 0; slot < list.size(); ++slot) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(slot));
            if (stack.m_41619_()) continue;
            int finalSlot = slot;
            accesses.add(containerAccess.chain(stack, (containerCt, newStack) -> {
                CompoundTag newInvTag = container.m_41698_("ItemInv");
                ListTag invList = newInvTag.m_128437_("ItemInv", 10);
                CompoundTag newItemTag = new CompoundTag();
                newStack.m_41739_(newItemTag);
                invList.set(finalSlot, (Tag)newItemTag);
                newInvTag.m_128365_("ItemInv", (Tag)invList);
            }));
        }
        return accesses;
    }

    private static List<ItemAccess> getBundleItemAccess(ItemAccess containerAccess) {
        Item item = containerAccess.item;
        if (!(item instanceof BundleItem)) {
            return Collections.emptyList();
        }
        ItemStack container = containerAccess.stack;
        if (!container.m_41782_()) {
            return Collections.emptyList();
        }
        CompoundTag tag = container.m_41784_();
        ListTag itemList = tag.m_128437_("Items", 10);
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        for (int slot = 0; slot < itemList.size(); ++slot) {
            CompoundTag itemTag = itemList.m_128728_(slot);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemTag);
            if (itemStack.m_41619_()) continue;
            int finalSlot = slot;
            accesses.add(containerAccess.chain(itemStack, (containerCt, newStack) -> {
                CompoundTag newTag = containerCt.m_41784_();
                ListTag newItemList = newTag.m_128437_("Items", 10);
                CompoundTag newItemTag = new CompoundTag();
                newStack.m_41739_(newItemTag);
                newItemList.set(finalSlot, (Tag)newItemTag);
                newTag.m_128365_("Items", (Tag)newItemList);
            }));
        }
        return accesses;
    }

    public static List<ItemAccess> getKeyringItemAccess(ItemAccess access) {
        if (!(access.item instanceof ItemVaultKeyring)) {
            return Collections.emptyList();
        }
        OverSizedInventory contents = ItemVaultKeyring.getInventory(access.stack);
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        for (int slot = 0; slot < contents.m_6643_(); ++slot) {
            ItemStack stack = contents.m_8020_(slot);
            if (stack.m_41619_()) continue;
            int finalSlot = slot;
            accesses.add(access.chain(stack, (containerStack, newStack) -> {
                OverSizedInventory ctContents = ItemVaultKeyring.getInventory(containerStack);
                ctContents.m_6836_(finalSlot, (ItemStack)newStack);
            }));
        }
        return accesses;
    }

    public static List<ItemAccess> getCoinPouchItemAccess(ItemAccess access) {
        if (!(access.item instanceof CoinPouchItem)) {
            return Collections.emptyList();
        }
        ItemStack container = access.stack;
        ItemStack[] contents = CoinPouchItem.getContainedStacks(container);
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        for (int slot = 0; slot < contents.length; ++slot) {
            ItemStack stack = contents[slot];
            if (stack.m_41619_()) continue;
            int finalSlot = slot;
            accesses.add(access.chain(stack, (containerStack, newStack) -> {
                ItemStack[] ctContents = CoinPouchItem.getContainedStacks(containerStack);
                ctContents[finalSlot] = newStack;
                CoinPouchItem.setContainedStack(containerStack, finalSlot, newStack.m_41613_());
            }));
        }
        return accesses;
    }

    private static List<ItemAccess> getShulkerBoxAccess(ItemAccess containerAccess) {
        BlockItem blockItem;
        Item item = containerAccess.item;
        if (!InventoryUtil.isShulkerBox(item)) {
            return Collections.emptyList();
        }
        ItemStack container = containerAccess.stack;
        CompoundTag tag = BlockItem.m_186336_((ItemStack)container);
        if (tag == null) {
            return Collections.emptyList();
        }
        Item item2 = container.m_41720_();
        int returnSize = item2 instanceof BlockItem && (blockItem = (BlockItem)item2).m_40614_() instanceof VaultBarrelBlock ? (container.m_150930_(ModBlocks.WOODEN_BARREL.m_5456_()) ? 36 : 45) : 27;
        NonNullList contents = NonNullList.m_122780_((int)returnSize, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)contents);
        ArrayList<ItemAccess> accesses = new ArrayList<ItemAccess>();
        for (int slot = 0; slot < contents.size(); ++slot) {
            ItemStack stack = (ItemStack)contents.get(slot);
            if (stack.m_41619_()) continue;
            int finalSlot = slot;
            accesses.add(containerAccess.chain(stack, (containerStack, newStack) -> {
                NonNullList ctContents = NonNullList.m_122780_((int)returnSize, (Object)ItemStack.f_41583_);
                CompoundTag ctTag = BlockItem.m_186336_((ItemStack)containerStack);
                if (ctTag != null) {
                    ContainerHelper.m_18980_((CompoundTag)ctTag, (NonNullList)ctContents);
                    ctContents.set(finalSlot, newStack);
                    ContainerHelper.m_18973_((CompoundTag)ctTag, (NonNullList)ctContents);
                    containerStack.m_41700_("BlockEntityTag", (Tag)ctTag);
                }
            }));
        }
        return accesses;
    }

    public static boolean doesntMatch(ItemAccess containerAccess, String wantedId) {
        Item item = containerAccess.item;
        return item == null || !wantedId.equals(item.getRegistryName() != null ? item.getRegistryName().toString() : "");
    }

    private static boolean isShulkerBox(Item item) {
        BlockItem blockItem;
        return item instanceof BlockItem && ((blockItem = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock || blockItem.m_40614_() instanceof VaultBarrelBlock);
    }

    public static boolean hasItem(NonNullList<ItemStack> items, Predicate<ItemStack> predicate) {
        for (ItemStack item : items) {
            if (item.m_41619_() || !predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public static Optional<ItemStack> getFirst(NonNullList<ItemStack> items, Predicate<ItemStack> predicate) {
        for (ItemStack item : items) {
            if (item.m_41619_() || !predicate.test(item)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    public static class ItemAccess {
        private ItemStack stack;
        private Item item;
        private final Consumer<ItemStack> setter;

        public ItemAccess(ItemStack stack) {
            this(stack, newStack -> {});
        }

        public ItemAccess(ItemStack stack, Consumer<ItemStack> setter) {
            this.stack = stack;
            this.item = stack.m_41720_();
            this.setter = setter;
        }

        public ItemAccess chain(ItemStack containedItem, BiConsumer<ItemStack, ItemStack> containedItemSetter) {
            return new ItemAccess(containedItem, newStack -> {
                ItemStack container = this.stack.m_41777_();
                containedItemSetter.accept(container, (ItemStack)newStack);
                this.setStack(container);
            });
        }

        public Item getItem() {
            return this.item;
        }

        public ItemStack getStack() {
            return this.stack.m_41777_();
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
            this.item = stack.m_41720_();
            this.setter.accept(stack);
        }
    }
}

