/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.util.ScreenParticle;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class LegendaryScreenParticle
extends ScreenParticle {
    public int[] particleColours = new int[]{-3666, -10091, -999556, -2644381, -4289206};
    protected Random random = new Random();
    protected float angleMin;
    protected float angleMax;
    protected float speedMin;
    protected float speedMax;
    protected int delayMin;
    protected int delayMax;
    protected int lifetimeMin;
    protected int lifetimeMax;
    protected int sizeMin;
    protected int sizeMax;
    protected int quantityMin;
    protected int quantityMax;
    protected Vec3 spawnerPos = new Vec3(0.0, 0.0, 0.0);
    protected float spawnerHeight;
    protected float spawnerWidth;
    protected List<ScreenParticle.Particle> particles = new LinkedList<ScreenParticle.Particle>();

    public LegendaryScreenParticle particleColours(int ... colours) {
        this.particleColours = colours;
        return this;
    }

    @Override
    public LegendaryScreenParticle angleRange(float min, float max) {
        this.angleMin = (float)Math.toRadians(min);
        this.angleMax = (float)Math.toRadians(max);
        return this;
    }

    @Override
    public LegendaryScreenParticle speedRange(float min, float max) {
        this.speedMin = min;
        this.speedMax = max;
        return this;
    }

    @Override
    public LegendaryScreenParticle delayRange(int min, int max) {
        this.delayMin = min;
        this.delayMax = max;
        return this;
    }

    @Override
    public LegendaryScreenParticle lifespanRange(int min, int max) {
        this.lifetimeMin = min;
        this.lifetimeMax = max;
        return this;
    }

    @Override
    public LegendaryScreenParticle sizeRange(int min, int max) {
        this.sizeMin = min;
        this.sizeMax = max;
        return this;
    }

    @Override
    public LegendaryScreenParticle quantityRange(int min, int max) {
        this.quantityMin = min;
        this.quantityMax = max;
        return this;
    }

    @Override
    public LegendaryScreenParticle spawnedPosition(int x, int y) {
        this.spawnerPos = new Vec3((double)x, (double)y, 0.0);
        return this;
    }

    @Override
    public LegendaryScreenParticle spawnedWidthHeight(int w, int h) {
        this.spawnerWidth = w;
        this.spawnerHeight = h;
        return this;
    }

    private int randi(int min, int max) {
        return min == max ? min : this.random.nextInt(max - min) + min;
    }

    private float randf(float min, float max) {
        return min == max ? min : this.random.nextFloat() * (max - min) + min;
    }

    @Override
    public void tick() {
        for (ScreenParticle.Particle particle : this.particles) {
            if (particle.hasDelay()) {
                --particle.tickDelay;
                continue;
            }
            particle.posO = particle.pos;
            particle.roll += particle.rollSpeed * (float)particle.rollDir;
            particle.pos = particle.pos.m_82549_(particle.velocity);
            particle.velocity = particle.velocity.m_82490_(0.97);
            particle.velocity = particle.velocity.m_82549_(particle.velocityAdded);
            ++particle.ticksLived;
        }
        this.particles.removeIf(ScreenParticle.Particle::shouldDespawn);
    }

    @Override
    public void render(PoseStack matrixStack, float partialTick) {
        for (ScreenParticle.Particle particle : this.particles) {
            double x0 = particle.pos.m_7096_() - (double)particle.size / 2.0;
            double y0 = particle.pos.m_7098_() - (double)particle.size / 2.0;
            double x0Old = particle.posO.m_7096_() - (double)particle.size / 2.0;
            double y0Old = particle.posO.m_7098_() - (double)particle.size / 2.0;
            matrixStack.m_85836_();
            matrixStack.m_85837_(Mth.m_14139_((double)partialTick, (double)x0, (double)x0Old), Mth.m_14139_((double)partialTick, (double)y0, (double)y0Old), 0.0);
            matrixStack.m_85841_(1.0f - (float)Math.pow((float)particle.ticksLived / (float)particle.ticksLifespan, 5.0), 1.0f - (float)Math.pow((float)particle.ticksLived / (float)particle.ticksLifespan, 5.0), 1.0f);
            GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)particle.size, (int)particle.size, (int)particle.color);
            matrixStack.m_85849_();
        }
        RenderSystem.m_69478_();
    }

    @Override
    public void pop() {
        this.pop(1.0f, 1.0f);
    }

    @Override
    public void pop(float velocityMul, float quantityMul) {
        int quantity = (int)((float)this.randi(this.quantityMin, this.quantityMax) * quantityMul);
        for (int i = 0; i < quantity; ++i) {
            ScreenParticle.Particle particle = new ScreenParticle.Particle();
            particle.rollSpeed += Mth.m_144924_((Random)this.random, (float)0.0f, (float)20.0f);
            particle.roll = particle.rollSpeed * (float)this.random.nextInt(20);
            particle.velocity = new Vec3(1.0, 0.0, 0.0).m_82535_(-this.randf(this.angleMin, this.angleMax)).m_82490_((double)this.randf(this.speedMin, this.speedMax)).m_82490_((double)velocityMul);
            particle.velocityAdded = new Vec3(0.0, (double)Mth.m_144924_((Random)this.random, (float)-0.02f, (float)0.02f), 0.0);
            particle.size = this.randi(this.sizeMin, this.sizeMax);
            particle.posO = particle.pos = new Vec3(this.spawnerPos.f_82479_ + (double)Mth.m_144924_((Random)this.random, (float)0.0f, (float)this.spawnerWidth), this.spawnerPos.f_82480_ + (double)Mth.m_144924_((Random)this.random, (float)0.0f, (float)this.spawnerHeight), 0.0);
            particle.rollDir = this.random.nextBoolean() ? -1 : 1;
            particle.color = this.particleColours[this.random.nextInt(this.particleColours.length)];
            particle.tickDelay = this.randi(this.delayMin, this.delayMax);
            particle.ticksLifespan = this.randi(this.lifetimeMin, this.lifetimeMax);
            this.particles.add(particle);
        }
    }
}

