/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class NetcodeUtils {
    public static void runIfPresent(@Nullable MinecraftServer server, @Nonnull UUID uuid, Consumer<ServerPlayer> action) {
        NetcodeUtils.runIfPresent(server, uuid, (ServerPlayer sPlayer) -> {
            action.accept((ServerPlayer)sPlayer);
            return null;
        });
    }

    public static <T> Optional<T> runIfPresent(@Nullable MinecraftServer server, @Nonnull UUID uuid, Function<ServerPlayer, T> action) {
        if (server == null) {
            return Optional.empty();
        }
        ServerPlayer player = server.m_6846_().m_11259_(uuid);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(action.apply(player));
    }

    public static void writeString(ByteBuf buf, String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    public static String readString(ByteBuf buf) {
        byte[] bytes = new byte[buf.readInt()];
        buf.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void writeIdentifier(ByteBuf buf, ResourceLocation identifier) {
        NetcodeUtils.writeString(buf, identifier.toString());
    }

    public static ResourceLocation readIdentifier(ByteBuf buf) {
        return new ResourceLocation(NetcodeUtils.readString(buf));
    }

    public static <T> void writeCollection(ByteBuf buf, Collection<T> collection, BiConsumer<T, ByteBuf> elementWriter) {
        buf.writeInt(collection.size());
        for (T element : collection) {
            elementWriter.accept(element, buf);
        }
    }

    public static <T, C extends Collection<T>> C readCollection(ByteBuf buf, IntFunction<C> supplier, Function<ByteBuf, T> elementReader) {
        int size = buf.readInt();
        Collection collection = (Collection)supplier.apply(size);
        for (int i = 0; i < size; ++i) {
            collection.add(elementReader.apply(buf));
        }
        return (C)collection;
    }
}

