/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.init.ModEffects;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.BerserkPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.util.damage.PlayerDamageHelper;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerBerserkHelper {
    public static final int MAX_STACKS = 20;
    public static final int DURATION_TICKS = 400;

    private PlayerBerserkHelper() {
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        PrestigeTree tree = PrestigeHelper.getPrestige((Player)player);
        if (tree.getAll(BerserkPrestigePower.class, Skill::isUnlocked).isEmpty()) {
            return;
        }
        MobEffectInstance current = player.m_21124_(ModEffects.BERSERK);
        int amplifier = current == null ? 0 : Mth.m_14045_((int)(current.m_19564_() + 1), (int)0, (int)19);
        player.m_7292_(new MobEffectInstance(ModEffects.BERSERK, 400, amplifier, false, false, true));
    }

    @SubscribeEvent
    public static void onDimensionChange(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.m_21195_(ModEffects.BERSERK);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.m_21195_(ModEffects.BERSERK);
        }
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.m_21195_(ModEffects.BERSERK);
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        MobEffectInstance instance = player2.m_21124_(ModEffects.BERSERK);
        if (instance == null) {
            return;
        }
        BerserkEffect effect = (BerserkEffect)ModEffects.BERSERK;
        effect.m_6385_((LivingEntity)player2, player2.m_21204_(), instance.m_19564_());
    }

    public static class BerserkEffect
    extends MobEffect {
        private static final float MULTIPLIER_PER_STACK = 0.05f;
        private final UUID uuid;

        public BerserkEffect(int color, ResourceLocation id) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(id);
            this.uuid = UUID.nameUUIDFromBytes(id.toString().getBytes(StandardCharsets.UTF_8));
        }

        public void m_6385_(@Nonnull LivingEntity entity, AttributeMap attributeMap, int amplifier) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                PlayerDamageHelper.removeMultiplier(player, this.uuid);
                PlayerDamageHelper.applyMultiplier(this.uuid, player, (float)(amplifier + 1) * 0.05f, PlayerDamageHelper.Operation.ADDITIVE_MULTIPLY);
            }
        }

        public void m_6386_(@Nonnull LivingEntity entity, AttributeMap attributeMap, int amplifier) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                PlayerDamageHelper.removeMultiplier(player, this.uuid);
            }
        }
    }
}

