/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.EntityLeechEvent;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModSounds;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.util.calc.LeechHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerLeechHelper {
    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent event) {
        Entity entity;
        if (!event.getEntity().f_19853_.m_5776_() && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            PlayerLeechHelper.onLeech(attacker, event.getEntityLiving(), event.getAmount(), LeechHelper.getLeechPercent(attacker));
        }
    }

    public static void onLeech(LivingEntity attacker, LivingEntity attacked, float damage, float leech) {
        Player player;
        if (ActiveFlags.IS_AOE_ATTACKING.isSet() || ActiveFlags.IS_DOT_ATTACKING.isSet() || ActiveFlags.IS_REFLECT_ATTACKING.isSet() || ActiveFlags.IS_JAVELIN_ATTACKING.isSet() || ActiveFlags.IS_CHARMED_ATTACKING.isSet() || ActiveFlags.IS_EFFECT_ATTACKING.isSet() || ActiveFlags.IS_TOTEM_ATTACKING.isSet()) {
            return;
        }
        if (attacker instanceof Player && AttackScaleHelper.getLastAttackScale(player = (Player)attacker) < 1.0f) {
            return;
        }
        if ((double)(leech = Math.min(leech, damage / attacked.m_21233_())) <= 1.0E-4) {
            return;
        }
        float amountLeeched = attacker.m_21233_() * leech;
        ActiveFlags.IS_LEECHING.runIfNotSet(() -> attacker.m_5634_(amountLeeched));
        if ((double)attacker.m_21187_().nextFloat() <= 0.2) {
            float pitch = MathUtilities.randomFloat(1.0f, 1.5f);
            attacker.m_20193_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), ModSounds.VAMPIRE_HISSING_SFX, SoundSource.MASTER, 0.020000001f, pitch);
        }
        CommonEvents.ENTITY_LEECH.invoke(new EntityLeechEvent.Data(attacker, attacked, amountLeeched));
    }
}

