/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.init.ModEffects;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.util.damage.PlayerDamageHelper;
import iskallia.vault.world.data.ServerVaults;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class PlayerRageHelper {
    public static final int MAX_RAGE = 100;
    public static final int RAGE_DURATION_TICKS = 10;
    private static final Map<UUID, Integer> LAST_ATTACK_TICK_MAP = new HashMap<UUID, Integer>();

    private PlayerRageHelper() {
    }

    public static int getRagePerHit(LivingEntity entity) {
        float result = 0.0f;
        result = CommonEvents.PLAYER_STAT.invoke(PlayerStat.RAGE_PER_HIT, entity, result).getValue();
        return Mth.m_14045_((int)Math.round(result), (int)0, (int)100);
    }

    public static float getRageDamagePerPoint(LivingEntity entity) {
        float result = 0.0f;
        result = CommonEvents.PLAYER_STAT.invoke(PlayerStat.RAGE_DAMAGE, entity, result).getValue();
        return Math.max(0.0f, result);
    }

    public static int getCurrentRage(LivingEntity entity) {
        MobEffectInstance effect = entity.m_21124_((MobEffect)ModEffects.RAGE);
        if (effect == null) {
            return 0;
        }
        return effect.m_19564_() + 1;
    }

    @SubscribeEvent
    public static void on(EntityTravelToDimensionEvent event) {
        ServerPlayer player;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer) || ServerVaults.get((Level)(player = (ServerPlayer)entity).m_183503_()).isEmpty()) {
            return;
        }
        player.m_21195_((MobEffect)ModEffects.RAGE);
    }

    @SubscribeEvent
    public static void on(LivingHurtEvent event) {
        ServerPlayer player;
        Entity entity;
        LivingEntity entityLiving = event.getEntityLiving();
        if (entityLiving.m_183503_().m_5776_() || !((entity = event.getSource().m_7639_()) instanceof ServerPlayer) || LAST_ATTACK_TICK_MAP.getOrDefault((player = (ServerPlayer)entity).m_142081_(), 0) > player.f_19797_ - 10) {
            return;
        }
        int ragePerHit = PlayerRageHelper.getRagePerHit((LivingEntity)player);
        if (ragePerHit == 0) {
            return;
        }
        MobEffectInstance effect = player.m_21124_((MobEffect)ModEffects.RAGE);
        if (effect == null) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.RAGE, ragePerHit * 10, 0, false, false, true));
        } else {
            int amplifier = effect.m_19564_();
            int newAmplifier = Math.min(99, amplifier + ragePerHit);
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.RAGE, (newAmplifier + 1) * 10, newAmplifier, false, false, true));
        }
        LAST_ATTACK_TICK_MAP.put(player.m_142081_(), player.f_19797_);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void on(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            LAST_ATTACK_TICK_MAP.remove(player.m_142081_());
        }
    }

    public static class RageEffect
    extends MobEffect {
        private final UUID uuid;

        public RageEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
            this.uuid = UUID.nameUUIDFromBytes(resourceLocation.toString().getBytes(StandardCharsets.UTF_8));
        }

        public boolean m_6584_(int duration, int amplifier) {
            return amplifier * 10 >= duration;
        }

        public void m_6742_(@Nonnull LivingEntity livingEntity, int amplifier) {
            livingEntity.m_21195_((MobEffect)this);
            if (amplifier > 0) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)this, 10 * amplifier, amplifier - 1, false, false, true));
            }
        }

        @ParametersAreNonnullByDefault
        public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                float multiplier = PlayerRageHelper.getRageDamagePerPoint(livingEntity);
                PlayerDamageHelper.removeMultiplier(player, this.uuid);
                PlayerDamageHelper.applyMultiplier(this.uuid, player, (float)(amplifier + 1) * multiplier, PlayerDamageHelper.Operation.ADDITIVE_MULTIPLY);
            }
        }

        @ParametersAreNonnullByDefault
        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                PlayerDamageHelper.removeMultiplier(player, this.uuid);
            }
        }
    }
}

