/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.gear.attribute.custom.RelentlessStrikeAttribute;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.util.damage.PlayerDamageHelper;
import iskallia.vault.world.data.ServerVaults;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class PlayerRelentlessStrikeHelper {
    public static final int MAX_STACKS = 10;
    public static final int RELENTLESS_DURATION_TICKS = 60;
    private static final Map<UUID, Integer> LAST_ATTACK_TICK_MAP = new HashMap<UUID, Integer>();

    private PlayerRelentlessStrikeHelper() {
    }

    public static int getDamagePerHit(LivingEntity entity) {
        float result = 0.0f;
        result = CommonEvents.PLAYER_STAT.invoke(PlayerStat.RELENTLESS_STRIKE, entity, result).getValue();
        return Mth.m_14045_((int)Math.round(result), (int)0, (int)10);
    }

    public static float getDamagePerPoint(LivingEntity entity) {
        float result = 0.0f;
        result = CommonEvents.PLAYER_STAT.invoke(PlayerStat.RELENTLESS_STRIKE, entity, result).getValue();
        return Math.max(0.0f, result);
    }

    public static int getCurrentRetribution(LivingEntity entity) {
        MobEffectInstance effect = entity.m_21124_(ModEffects.RELENTLESS_STRIKE);
        if (effect == null) {
            return 0;
        }
        return effect.m_19564_() + 1;
    }

    @SubscribeEvent
    public static void on(EntityTravelToDimensionEvent event) {
        ServerPlayer player;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer) || ServerVaults.get((Level)(player = (ServerPlayer)entity).m_183503_()).isEmpty()) {
            return;
        }
        player.m_21195_(ModEffects.RELENTLESS_STRIKE);
    }

    @SubscribeEvent
    public static void on(LivingHurtEvent event) {
        MobEffectInstance effect;
        VaultGearItem gearItem;
        ServerPlayer player;
        Entity entity;
        LivingEntity entityLiving = event.getEntityLiving();
        if (entityLiving.m_183503_().m_5776_() || !((entity = event.getSource().m_7639_()) instanceof ServerPlayer) || LAST_ATTACK_TICK_MAP.getOrDefault((player = (ServerPlayer)entity).m_142081_(), 0) > player.f_19797_ - 10) {
            return;
        }
        if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet() || ActiveFlags.IS_AOE_ATTACKING.isSet() || ActiveFlags.IS_TOTEM_ATTACKING.isSet() || ActiveFlags.IS_CHARMED_ATTACKING.isSet() || ActiveFlags.IS_DOT_ATTACKING.isSet() || ActiveFlags.IS_REFLECT_ATTACKING.isSet() || ActiveFlags.IS_EFFECT_ATTACKING.isSet() || ActiveFlags.IS_THORNS_REFLECTING.isSet() || ActiveFlags.IS_FIRESHOT_ATTACKING.isSet() || ActiveFlags.IS_ARCANE_RAIL_ATTACKING.isSet() || ActiveFlags.IS_GLACIAL_SHATTER_ATTACKING.isSet()) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof VaultGearItem) || (gearItem = (VaultGearItem)item).isBroken(heldItem)) {
            return;
        }
        VaultGearData data = VaultGearData.read(heldItem);
        Optional<Float> relentlessStrikeDamage = data.getFirstValue(ModGearAttributes.RELENTLESS_STRIKE);
        Optional<RelentlessStrikeAttribute> relentlessStrikeAttribute = data.getFirstValue(ModGearAttributes.RELENTLESS_STRIKE_ATTRIBUTE);
        if (relentlessStrikeDamage.isEmpty() && relentlessStrikeAttribute.isEmpty()) {
            return;
        }
        int maxStacks = 10;
        if (relentlessStrikeAttribute.isPresent()) {
            maxStacks = relentlessStrikeAttribute.get().getMaxStackSize();
        }
        if ((effect = player.m_21124_(ModEffects.RELENTLESS_STRIKE)) == null) {
            player.m_7292_(new MobEffectInstance(ModEffects.RELENTLESS_STRIKE, 60, 0, false, false, true));
        } else {
            int amplifier = effect.m_19564_();
            int newAmplifier = Math.min(maxStacks - 1, amplifier + 1);
            player.m_7292_(new MobEffectInstance(ModEffects.RELENTLESS_STRIKE, 60 * (newAmplifier + 1), newAmplifier, false, false, true));
        }
        LAST_ATTACK_TICK_MAP.put(player.m_142081_(), player.f_19797_);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void on(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            LAST_ATTACK_TICK_MAP.remove(player.m_142081_());
        }
    }

    @SubscribeEvent
    public static void on(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            LAST_ATTACK_TICK_MAP.remove(player2.m_142081_());
        }
    }

    @SubscribeEvent
    public static void on(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        MobEffectInstance instance = player2.m_21124_(ModEffects.RELENTLESS_STRIKE);
        if (instance == null) {
            return;
        }
        RelentlessStrikeEffect effect = (RelentlessStrikeEffect)ModEffects.RELENTLESS_STRIKE;
        effect.m_6385_((LivingEntity)player2, player2.m_21204_(), instance.m_19564_());
    }

    public static void clearEffects(ServerPlayer player) {
        player.m_21195_(ModEffects.RELENTLESS_STRIKE);
        LAST_ATTACK_TICK_MAP.remove(player.m_142081_());
    }

    public static class RelentlessStrikeEffect
    extends MobEffect {
        private final UUID uuid;

        public RelentlessStrikeEffect(int color, ResourceLocation resourceLocation) {
            super(MobEffectCategory.BENEFICIAL, color);
            this.setRegistryName(resourceLocation);
            this.uuid = UUID.nameUUIDFromBytes(resourceLocation.toString().getBytes(StandardCharsets.UTF_8));
        }

        public boolean m_6584_(int duration, int amplifier) {
            return amplifier * 60 >= duration;
        }

        public void m_6742_(@Nonnull LivingEntity livingEntity, int amplifier) {
            livingEntity.m_21195_((MobEffect)this);
            if (amplifier > 0) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)this, 60 * amplifier, amplifier - 1, false, false, true));
            }
        }

        @ParametersAreNonnullByDefault
        public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                float multiplier = PlayerRelentlessStrikeHelper.getDamagePerPoint(livingEntity);
                PlayerDamageHelper.removeMultiplier(player, this.uuid);
                PlayerDamageHelper.applyMultiplier(this.uuid, player, (float)(amplifier + 1) * multiplier, PlayerDamageHelper.Operation.ADDITIVE_MULTIPLY);
            }
        }

        @ParametersAreNonnullByDefault
        public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int amplifier) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                PlayerDamageHelper.removeMultiplier(player, this.uuid);
            }
        }
    }
}

