/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.VaultMod;
import iskallia.vault.event.event.VaultGearEquipmentChangeEvent;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.util.damage.PlayerDamageHelper;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public final class PlayerThirdAttackDamageHelper {
    private static final Map<UUID, Integer> ATTACK_COUNTER = new HashMap<UUID, Integer>();
    private static final UUID damageMultiplerUUID = UUID.nameUUIDFromBytes(VaultMod.id("third_attack_damage").toString().getBytes(StandardCharsets.UTF_8));

    private PlayerThirdAttackDamageHelper() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(LivingHurtEvent event) {
        VaultGearItem gearItem;
        ServerPlayer player;
        block9: {
            block8: {
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof ServerPlayer)) break block8;
                player = (ServerPlayer)entity;
                if (!event.getEntityLiving().m_183503_().m_5776_()) break block9;
            }
            return;
        }
        ItemStack heldItem = player.m_21206_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof VaultGearItem) || (gearItem = (VaultGearItem)item).isBroken(heldItem)) {
            return;
        }
        VaultGearData data = VaultGearData.read(heldItem);
        Optional<Float> thirdAttackDamage = data.getFirstValue(ModGearAttributes.THIRD_ATTACK);
        if (thirdAttackDamage.isEmpty()) {
            return;
        }
        UUID playerId = player.m_142081_();
        int currentCount = ATTACK_COUNTER.getOrDefault(playerId, 0) + 1;
        if (currentCount >= 3) {
            float multiplier = thirdAttackDamage.get().floatValue();
            PlayerDamageHelper.applyMultiplier(damageMultiplerUUID, player, multiplier, PlayerDamageHelper.Operation.ADDITIVE_MULTIPLY, true);
            currentCount = 0;
        } else if (PlayerDamageHelper.hasMultiplier(player, damageMultiplerUUID)) {
            PlayerDamageHelper.removeMultiplier(player, damageMultiplerUUID);
        }
        ATTACK_COUNTER.put(playerId, currentCount);
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ATTACK_COUNTER.remove(player.m_142081_());
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ATTACK_COUNTER.remove(player.m_142081_());
        }
    }

    @SubscribeEvent
    public static void onGearAttributeChange(VaultGearEquipmentChangeEvent event) {
        ServerPlayer player = event.getPlayer();
        UUID playerId = player.m_142081_();
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            PlayerThirdAttackDamageHelper.clearThirdAttackEffects(player);
            return;
        }
        ServerScheduler.INSTANCE.schedule(1, () -> {
            ServerPlayer currentPlayer = server.m_6846_().m_11259_(playerId);
            if (currentPlayer == null) {
                ATTACK_COUNTER.remove(playerId);
                PlayerDamageHelper.removeMultiplier(player, damageMultiplerUUID);
                return;
            }
            float thirdAttackTotal = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)currentPlayer).getAttributeValue(ModGearAttributes.THIRD_ATTACK, VaultGearAttributeTypeMerger.floatSum()).floatValue();
            if (thirdAttackTotal <= 0.0f) {
                PlayerThirdAttackDamageHelper.clearThirdAttackEffects(currentPlayer);
            }
        });
    }

    private static void clearThirdAttackEffects(ServerPlayer player) {
        UUID playerId = player.m_142081_();
        ATTACK_COUNTER.remove(playerId);
        if (PlayerDamageHelper.hasMultiplier(player, damageMultiplerUUID)) {
            PlayerDamageHelper.removeMultiplier(player, damageMultiplerUUID);
        }
    }
}

