/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.client.ClientDamageData;
import iskallia.vault.client.ClientTalentData;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.talent.type.PuristTalent;
import iskallia.vault.skill.talent.type.luckyhit.DamageLuckyHitTalent;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.BlockChanceHelper;
import iskallia.vault.util.calc.ResistanceHelper;
import iskallia.vault.util.damage.PlayerDamageHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class StatUtils {
    public static double getAverageDps(Player player) {
        LearnableSkill learnableSkill;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot((LivingEntity)player);
        double attackSpeed = player.m_21133_(Attributes.f_22283_);
        double attackDamage = player.m_21133_(Attributes.f_22281_);
        double luckyHitChance = snapshot.getAttributeValue(ModGearAttributes.LUCKY_HIT_CHANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        if (luckyHitChance != 0.0) {
            float luckyHitMultiplier = 1.1f;
            for (TieredSkill learnedTalentNode : ClientTalentData.getLearnedTalentNodes()) {
                learnableSkill = learnedTalentNode.getChild();
                if (!(learnableSkill instanceof DamageLuckyHitTalent)) continue;
                DamageLuckyHitTalent damageLuckyHitTalent = (DamageLuckyHitTalent)learnableSkill;
                luckyHitMultiplier = 1.0f + damageLuckyHitTalent.getDamageIncrease();
            }
            attackDamage *= 1.0 - luckyHitChance + (double)luckyHitMultiplier * luckyHitChance;
        }
        float dmgIncrease = snapshot.getAttributeValue(ModGearAttributes.DAMAGE_INCREASE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        for (TieredSkill node : ClientTalentData.getLearnedTalentNodes()) {
            learnableSkill = node.getChild();
            if (!(learnableSkill instanceof PuristTalent)) continue;
            PuristTalent talent = (PuristTalent)learnableSkill;
            dmgIncrease += talent.getDamageIncrease() * (float)talent.getCount((LivingEntity)player);
        }
        attackDamage *= (double)(1.0f + dmgIncrease);
        float dynamicDmgMultiplier = player instanceof ServerPlayer ? PlayerDamageHelper.getDamageMultiplier(player, true, false) : ClientDamageData.getCurrentDamageMultiplier();
        return (attackDamage *= (double)dynamicDmgMultiplier) * attackSpeed;
    }

    public static double getDefence(Player player) {
        int armor = player.m_21230_();
        float resistance = ResistanceHelper.getResistance((LivingEntity)player, null);
        float blockChance = BlockChanceHelper.getBlockChance((LivingEntity)player);
        double dmgReduction = StatUtils.getArmorMultiplier(armor);
        dmgReduction *= (double)(1.0f - resistance);
        return 1.0 - (dmgReduction *= (double)(1.0f - blockChance));
    }

    public static float getArmorMultiplier(float armor) {
        return 1.0f - 1.0f / ((float)Math.pow(40.0f / armor, 2.0) + 1.0f);
    }
}

