/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import java.util.Set;

public class StringUtils {
    private static final Set<String> LOWERCASE_WORDS = Set.of("of", "a", "an", "and", "the", "but", "or", "nor", "for", "so", "yet", "is");

    public static String truncateMaxLength(String original, int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException();
        }
        if (original == null || original.length() <= maxLength) {
            return original;
        }
        return original.substring(0, maxLength);
    }

    public static String convertToTitleCase(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder titleCase = new StringBuilder();
        StringBuilder currentWord = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (c == '_') {
                StringUtils.processWord(currentWord, titleCase);
                titleCase.append(' ');
                continue;
            }
            currentWord.append(c);
        }
        StringUtils.processWord(currentWord, titleCase);
        return titleCase.toString();
    }

    private static void processWord(StringBuilder currentWord, StringBuilder titleCase) {
        if (!currentWord.isEmpty()) {
            String word = currentWord.toString();
            if (LOWERCASE_WORDS.contains(word.toLowerCase())) {
                titleCase.append(word.toLowerCase());
            } else {
                titleCase.append(Character.toTitleCase(word.charAt(0)));
                titleCase.append(word.substring(1).toLowerCase());
            }
            currentWord.setLength(0);
        }
    }

    public static String pluralise(String word, int count) {
        if (count == 1) {
            return word;
        }
        return word + "s";
    }
}

