/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModConfigs;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class TextUtil {
    static final ChatFormatting[] rainbow = new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.BLUE, ChatFormatting.LIGHT_PURPLE, ChatFormatting.DARK_PURPLE};

    public static TextComponent applyRainbowTo(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            sb.append(TextUtil.getNextColor(i));
            sb.append(c);
        }
        return new TextComponent(sb.toString());
    }

    private static ChatFormatting getNextColor(int index) {
        return rainbow[index % rainbow.length];
    }

    public static TextComponent formatLocationPathAsProperNoun(ResourceLocation location) {
        String[] split = location.m_135815_().split("_");
        AtomicReference<String> name = new AtomicReference<String>("");
        Arrays.stream(split).forEach(s -> name.set((String)name.get() + StringUtils.capitalize((String)s) + " "));
        return new TextComponent(name.get().trim());
    }

    public static <T extends Component> TextComponent listToComponent(List<T> components) {
        TextComponent component = new TextComponent("");
        components.forEach(c -> {
            if (components.indexOf(c) == components.size() - 1) {
                component.m_7220_(c);
                return;
            }
            component.m_7220_(c).m_130946_("\n");
        });
        return component;
    }

    public static int getLineHeight(FormattedText component, int width) {
        return Minecraft.m_91087_().f_91062_.m_92923_(component, width).size();
    }

    public static MutableComponent applyColorTags(String text) {
        TextComponent result = new TextComponent("");
        int last = 0;
        Style current = Style.f_131099_;
        Matcher matcher = Pattern.compile("<(#[0-9a-fA-F]{6}|\\$[a-zA-Z_]+|[a-zA-Z_]+)>").matcher(text);
        while (matcher.find()) {
            String id;
            if (matcher.start() > last) {
                result.m_7220_((Component)new TextComponent(text.substring(last, matcher.start())).m_6270_(current));
            }
            if ((id = matcher.group(1)).startsWith("#")) {
                try {
                    int color = Integer.parseInt(id.substring(1), 16);
                    current = current.m_131148_(TextColor.m_131266_((int)color));
                }
                catch (NumberFormatException e) {
                    VaultMod.LOGGER.warn("Invalid hex color tag {}", (Object)id);
                }
            } else if (id.startsWith("$")) {
                current = current.m_131148_(ModConfigs.COLORS.getColor(id.substring(1)));
            } else {
                ChatFormatting fmt = ChatFormatting.m_126657_((String)id.toUpperCase());
                if (fmt != null) {
                    current = fmt == ChatFormatting.RESET ? Style.f_131099_ : current.m_131157_(fmt);
                } else {
                    result.m_7220_((Component)new TextComponent(matcher.group()).m_6270_(current));
                }
            }
            last = matcher.end();
        }
        if (last < text.length()) {
            result.m_7220_((Component)new TextComponent(text.substring(last)).m_6270_(current));
        }
        return result;
    }

    private static String toHexColorCode(String hex) {
        StringBuilder sb = new StringBuilder("\u00a7x");
        for (char c : hex.toCharArray()) {
            sb.append('\u00a7').append(c);
        }
        return sb.toString();
    }
}

