/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.entity.entity.VaultDamageNumberEntity;
import iskallia.vault.util.ServerScheduler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VaultDamageHelper {
    private static final Random RANDOM = new Random();
    private static final Map<UUID, Set<Integer>> ACTIVE_POSITIONS = new ConcurrentHashMap<UUID, Set<Integer>>();

    private static int getAvailablePosition(UUID entityId) {
        Iterator it;
        Set usedPositions = ACTIVE_POSITIONS.computeIfAbsent(entityId, k -> new HashSet());
        if (usedPositions.size() >= 5 && (it = usedPositions.iterator()).hasNext()) {
            it.next();
            it.remove();
        }
        ArrayList<Integer> availablePositions = new ArrayList<Integer>();
        for (int i = 0; i < 5; ++i) {
            if (usedPositions.contains(i)) continue;
            availablePositions.add(i);
        }
        int position = availablePositions.isEmpty() ? RANDOM.nextInt(5) : ((Integer)availablePositions.get(RANDOM.nextInt(availablePositions.size()))).intValue();
        usedPositions.add(position);
        VaultDamageHelper.schedulePositionCleanup(entityId, position);
        return position;
    }

    private static void schedulePositionCleanup(UUID entityId, int position) {
        int tickDelay = 45;
        ServerScheduler.INSTANCE.schedule(tickDelay, () -> {
            Set<Integer> positions = ACTIVE_POSITIONS.get(entityId);
            if (positions != null) {
                positions.remove(position);
                if (positions.isEmpty()) {
                    ACTIVE_POSITIONS.remove(entityId);
                }
            }
        });
    }

    private static double calculateHeightPosition(Entity target) {
        double heightFactor = 0.55;
        double absoluteHeight = target.m_20186_() + (double)target.m_20206_() * heightFactor;
        double minHeight = target.m_20186_() + 0.5;
        return Math.max(absoluteHeight, minHeight);
    }

    public static void spawnDamageNumber(Entity target, float damage, DamageSource source, ServerLevel level) {
        if (target == null || level == null || level.m_5776_()) {
            return;
        }
        ArrayList<UUID> trackingPlayers = new ArrayList<UUID>();
        for (Player player : level.m_6907_()) {
            if (!(player.m_20280_(target) < 4096.0)) continue;
            trackingPlayers.add(player.m_142081_());
        }
        if (trackingPlayers.isEmpty()) {
            return;
        }
        VaultDamageNumberEntity.DamageType damageType = VaultDamageNumberEntity.DamageType.fromDamageSource(source);
        int positionType = VaultDamageHelper.getAvailablePosition(target.m_142081_());
        VaultDamageNumberEntity damageNumber = new VaultDamageNumberEntity(damage, damageType, positionType, (Level)level, trackingPlayers);
        double angleOffset = (double)positionType * 1.2566370614359172;
        double radius = Math.min((double)target.m_20205_() * 0.3, 0.5);
        double offsetX = Math.sin(angleOffset) * radius;
        double offsetZ = Math.cos(angleOffset) * radius;
        double yPos = VaultDamageHelper.calculateHeightPosition(target);
        damageNumber.m_6034_(target.m_20185_() + offsetX, yPos, target.m_20189_() + offsetZ);
        damageNumber.setParentEntity(target);
        level.m_7967_((Entity)damageNumber);
    }

    public static void spawnCriticalDamageNumber(Entity target, float damage, ServerLevel level) {
        if (target == null || level == null || level.m_5776_()) {
            return;
        }
        ArrayList<UUID> trackingPlayers = new ArrayList<UUID>();
        for (Player player : level.m_6907_()) {
            if (!(player.m_20280_(target) < 4096.0)) continue;
            trackingPlayers.add(player.m_142081_());
        }
        if (trackingPlayers.isEmpty()) {
            return;
        }
        int positionType = VaultDamageHelper.getAvailablePosition(target.m_142081_());
        VaultDamageNumberEntity damageNumber = new VaultDamageNumberEntity(damage, VaultDamageNumberEntity.DamageType.CRITICAL, positionType, (Level)level, trackingPlayers);
        double angleOffset = (double)positionType * 1.2566370614359172;
        double radius = Math.min((double)target.m_20205_() * 0.3, 0.5);
        double offsetX = Math.sin(angleOffset) * radius;
        double offsetZ = Math.cos(angleOffset) * radius;
        double yPos = VaultDamageHelper.calculateHeightPosition(target);
        damageNumber.m_6034_(target.m_20185_() + offsetX, yPos, target.m_20189_() + offsetZ);
        damageNumber.setParentEntity(target);
        level.m_7967_((Entity)damageNumber);
    }
}

