/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.LuckyHitVortexParticleMessage;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.ServerScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class VortexHelper {
    private static final Map<ResourceKey<Level>, List<VortexEntry>> ACTIVE = new HashMap<ResourceKey<Level>, List<VortexEntry>>();

    public static void spawn(ServerLevel level, Vec3 center, float radius, int durationTicks, LivingEntity source) {
        ServerScheduler.INSTANCE.schedule(1, () -> {
            ACTIVE.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), k -> new ArrayList()).add(new VortexEntry(center, radius, durationTicks));
            if (source != null) {
                ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> source), (Object)new LuckyHitVortexParticleMessage(center, radius));
            }
        });
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.world.m_5776_()) {
            return;
        }
        List<VortexEntry> list = ACTIVE.get(event.world.m_46472_());
        if (list == null) {
            return;
        }
        for (VortexEntry entry : list) {
            if (!entry.valid) continue;
            ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
            EntityHelper.getEntitiesInRange((LevelAccessor)event.world, entry.center, entry.radius, entity -> EntityHelper.VAULT_TARGET_SELECTOR.test((Entity)entity), targets);
            for (LivingEntity target : targets) {
                Vec3 motion = entry.center.m_82546_(target.m_20182_());
                if (!(motion.m_82556_() > 0.001)) continue;
                Vec3 pull = motion.m_82541_().m_82490_(1.0);
                target.m_5997_(pull.f_82479_, pull.f_82480_ * 0.1, pull.f_82481_);
                target.f_19812_ = true;
            }
            if (entry.ticks % 5 == 0) {
                ModNetwork.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entry.center.f_82479_, entry.center.f_82480_, entry.center.f_82481_, 64.0, event.world.m_46472_())), (Object)new LuckyHitVortexParticleMessage(entry.center, entry.radius));
            }
            entry.decrement();
        }
        list.removeIf(e -> !e.valid);
    }

    private VortexHelper() {
    }

    private static class VortexEntry {
        private final Vec3 center;
        private final float radius;
        private int ticks;
        private boolean valid = true;

        private VortexEntry(Vec3 center, float radius, int ticks) {
            this.center = center;
            this.radius = radius;
            this.ticks = ticks;
        }

        private void decrement() {
            --this.ticks;
            if (this.ticks <= 0) {
                this.valid = false;
            }
        }
    }
}

