/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import iskallia.vault.gear.attribute.ability.AbilityAreaOfEffectFlatAttribute;
import iskallia.vault.gear.attribute.ability.AbilityAreaOfEffectPercentAttribute;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;

public class AreaOfEffectHelper {
    public static float adjustAreaOfEffectKey(LivingEntity entity, @Nullable String abilityKey, float range) {
        Skill ability = ModConfigs.ABILITIES.getAbilityById(abilityKey).orElse(null);
        return AreaOfEffectHelper.adjustAreaOfEffect(entity, ability, range);
    }

    public static float adjustAreaOfEffect(LivingEntity entity, @Nullable Skill ability, float range) {
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        if (ability != null) {
            for (AbilityAreaOfEffectFlatAttribute attribute : snapshot.getAttributeValue(ModGearAttributes.ABILITY_AREA_OF_EFFECT_FLAT, VaultGearAttributeTypeMerger.asList())) {
                range = ability.up((skill, rangeIt) -> Float.valueOf(attribute.adjustAreaOfEffect(skill.getId(), rangeIt.floatValue())), Float.valueOf(range)).floatValue();
            }
        }
        float multiplier = 1.0f;
        float adjustedRange = range * Math.max(0.0f, multiplier += snapshot.getAttributeValue(ModGearAttributes.AREA_OF_EFFECT, VaultGearAttributeTypeMerger.floatSum()).floatValue());
        if (ability != null) {
            for (AbilityAreaOfEffectPercentAttribute attribute : snapshot.getAttributeValue(ModGearAttributes.ABILITY_AREA_OF_EFFECT_PERCENT, VaultGearAttributeTypeMerger.asList())) {
                adjustedRange = ability.up((skill, rangeIt) -> Float.valueOf(attribute.adjustAreaOfEffect(skill.getId(), rangeIt.floatValue())), Float.valueOf(adjustedRange)).floatValue();
            }
        }
        return Math.max(adjustedRange, 0.0f);
    }

    public static int adjustAreaOfEffectRound(LivingEntity entity, @Nullable String abilityKey, int range) {
        return Math.round(AreaOfEffectHelper.adjustAreaOfEffectKey(entity, abilityKey, range));
    }

    public static int adjustAreaOfEffectRound(LivingEntity entity, @Nullable Skill ability, int range) {
        return Math.round(AreaOfEffectHelper.adjustAreaOfEffect(entity, ability, range));
    }
}

