/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.health.LowHealthResistanceTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.PlayerTalentsData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class AttributeLimitHelper {
    public static float getCooldownReductionLimit(LivingEntity entity) {
        float limit = 0.8f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        return Mth.m_14036_((float)(limit += snapshot.getAttributeValue(ModGearAttributes.COOLDOWN_REDUCTION_CAP, VaultGearAttributeTypeMerger.floatSum()).floatValue()), (float)0.0f, (float)0.95f);
    }

    public static float getBlockChanceLimit(LivingEntity entity) {
        float limit = 0.6f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        return Mth.m_14036_((float)(limit += snapshot.getAttributeValue(ModGearAttributes.BLOCK_CAP, VaultGearAttributeTypeMerger.floatSum()).floatValue()), (float)0.0f, (float)0.95f);
    }

    public static float getResistanceLimit(LivingEntity entity) {
        float limit = 0.5f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        limit += snapshot.getAttributeValue(ModGearAttributes.RESISTANCE_CAP, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            TalentTree tree = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
            for (LowHealthResistanceTalent talent : tree.getAll(LowHealthResistanceTalent.class, Skill::isUnlocked)) {
                if (!talent.shouldGetBenefits((LivingEntity)sPlayer)) continue;
                limit += talent.getAdditionalResistance();
            }
        }
        return Mth.m_14036_((float)limit, (float)0.0f, (float)0.95f);
    }

    public static float getDurabilityWearReductionLimit(LivingEntity entity) {
        float limit = 0.5f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        limit += snapshot.getAttributeValue(ModGearAttributes.DURABILITY_WEAR_REDUCTION_CAP, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        limit = (float)((double)limit + entity.m_21133_(ModAttributes.DURABILITY_WEAR_REDUCTION_CAP));
        limit = CommonEvents.PLAYER_STAT.invoke(PlayerStat.DURABILITY_WEAR_REDUCTION_CAP, entity, limit).getValue();
        return Mth.m_14036_((float)limit, (float)0.0f, (float)1.0f);
    }
}

