/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.calc;

import iskallia.vault.aura.ActiveAura;
import iskallia.vault.aura.AuraManager;
import iskallia.vault.aura.type.ResistanceAuraConfig;
import iskallia.vault.client.ClientTalentData;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.health.LowHealthResistanceTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.util.calc.AttributeLimitHelper;
import iskallia.vault.util.calc.PlayerStat;
import iskallia.vault.world.data.PlayerTalentsData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ResistanceHelper {
    public static float getResistance(LivingEntity entity, LivingEntity attacker) {
        return Mth.m_14036_((float)ResistanceHelper.getResistanceUnlimited(entity, attacker), (float)0.0f, (float)AttributeLimitHelper.getResistanceLimit(entity));
    }

    public static float getResistanceUnlimited(LivingEntity entity, LivingEntity attacker) {
        float resistancePercent = 0.0f;
        AttributeSnapshot snapshot = AttributeSnapshotHelper.getInstance().getSnapshot(entity);
        resistancePercent += snapshot.getAttributeValue(ModGearAttributes.RESISTANCE, VaultGearAttributeTypeMerger.floatSum()).floatValue();
        if (entity.m_21023_(ModEffects.RESISTANCE)) {
            resistancePercent += (float)(entity.m_21124_(ModEffects.RESISTANCE).m_19564_() + 1) / 100.0f;
        }
        for (ActiveAura aura : AuraManager.getInstance().getAurasAffecting((Entity)entity)) {
            if (!(aura.getAura() instanceof ResistanceAuraConfig)) continue;
            resistancePercent += ((ResistanceAuraConfig)aura.getAura()).getAdditionalResistance();
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            TalentTree tree = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
            for (LowHealthResistanceTalent talent : tree.getAll(LowHealthResistanceTalent.class, Skill::isUnlocked)) {
                if (!talent.shouldGetBenefits((LivingEntity)sPlayer)) continue;
                resistancePercent += talent.getAdditionalResistance();
            }
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            TalentTree tree = ClientTalentData.getTree();
            for (LowHealthResistanceTalent talent : tree.getAll(LowHealthResistanceTalent.class, Skill::isUnlocked)) {
                if (!talent.shouldGetBenefits((LivingEntity)player)) continue;
                resistancePercent += talent.getAdditionalResistance();
            }
        }
        resistancePercent = CommonEvents.PLAYER_STAT.invoke(PlayerStat.RESISTANCE, entity, resistancePercent, data -> data.setEnemy(attacker)).getValue();
        return resistancePercent;
    }
}

