/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.effect;

import iskallia.vault.util.ServerScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ScheduledEffectHelper {
    private static final Map<ResourceKey<Level>, List<DelayedEffectEntry>> DELAYED_EFFECT_ENTRIES = new HashMap<ResourceKey<Level>, List<DelayedEffectEntry>>();

    public static void scheduleEffect(LivingEntity entity, MobEffectInstance effectInstance, int delayTicks) {
        int entityId = entity.m_142049_();
        ServerScheduler.INSTANCE.schedule(1, () -> ScheduledEffectHelper.getEntries((Entity)entity).add(new DelayedEffectEntry(delayTicks, entityId, effectInstance)));
    }

    public static void invalidateAll(LivingEntity entity) {
        ScheduledEffectHelper.getEntries((Entity)entity).stream().filter(entry -> entry.matches(entity.m_142049_())).forEach(DelayedEffectEntry::invalidate);
    }

    public static void invalidateAll(LivingEntity entity, MobEffect effect) {
        ScheduledEffectHelper.getEntries((Entity)entity).stream().filter(entry -> entry.matches(entity.m_142049_()) && entry.matches(effect)).forEach(DelayedEffectEntry::invalidate);
    }

    public static void invalidateAll(Level level, MobEffect effect) {
        ScheduledEffectHelper.getEntries(level).stream().filter(entry -> entry.matches(effect)).forEach(DelayedEffectEntry::invalidate);
    }

    private static List<DelayedEffectEntry> getEntries(Entity entity) {
        return ScheduledEffectHelper.getEntries((ResourceKey<Level>)entity.m_183503_().m_46472_());
    }

    private static List<DelayedEffectEntry> getEntries(Level level) {
        return ScheduledEffectHelper.getEntries((ResourceKey<Level>)level.m_46472_());
    }

    private static List<DelayedEffectEntry> getEntries(ResourceKey<Level> key) {
        return DELAYED_EFFECT_ENTRIES.computeIfAbsent(key, levelResourceKey -> new ArrayList());
    }

    @SubscribeEvent
    public static void on(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.world.m_5776_()) {
            return;
        }
        List<DelayedEffectEntry> entries = ScheduledEffectHelper.getEntries(event.world);
        for (DelayedEffectEntry entry2 : entries) {
            if (!entry2.valid || entry2.remainingTicks > 0) continue;
            entry2.invalidate();
            Entity entity = event.world.m_6815_(entry2.entityId);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.m_6084_()) continue;
            livingEntity.m_7292_(entry2.effectInstance);
        }
        entries.forEach(DelayedEffectEntry::decrement);
        entries.removeIf(entry -> !entry.valid);
    }

    private ScheduledEffectHelper() {
    }

    private static class DelayedEffectEntry {
        private int remainingTicks;
        private final int entityId;
        private final MobEffectInstance effectInstance;
        private boolean valid = true;

        private DelayedEffectEntry(int remainingTicks, int entityId, MobEffectInstance effectInstance) {
            this.remainingTicks = remainingTicks;
            this.entityId = entityId;
            this.effectInstance = effectInstance;
        }

        private boolean matches(MobEffect effect) {
            return this.effectInstance.m_19544_() == effect;
        }

        private boolean matches(int entityId) {
            return this.entityId == entityId;
        }

        private void decrement() {
            --this.remainingTicks;
        }

        private void invalidate() {
            this.valid = false;
        }
    }
}

