/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.util.nbt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec2;

public class NBTHelper {
    public static IntArrayTag serializeBoundingBox(BoundingBox box) {
        return new IntArrayTag(new int[]{box.m_162395_(), box.m_162396_(), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_()});
    }

    public static BoundingBox deserializeBoundingBox(int[] v) {
        return new BoundingBox(v[0], v[1], v[2], v[3], v[4], v[5]);
    }

    public static CompoundTag serializeBlockPos(BlockPos pos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("posX", pos.m_123341_());
        tag.m_128405_("posY", pos.m_123342_());
        tag.m_128405_("posZ", pos.m_123343_());
        return tag;
    }

    public static BlockPos deserializeBlockPos(CompoundTag tag) {
        int x = tag.m_128451_("posX");
        int y = tag.m_128451_("posY");
        int z = tag.m_128451_("posZ");
        return new BlockPos(x, y, z);
    }

    public static CompoundTag serializeVec2(Vec2 vec) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("x", vec.f_82470_);
        tag.m_128350_("y", vec.f_82471_);
        return tag;
    }

    public static Vec2 deserializeVec2(CompoundTag tag) {
        float x = tag.m_128457_("x");
        float y = tag.m_128457_("y");
        return new Vec2(x, y);
    }

    public static <T, N extends Tag> Map<UUID, T> readMap(CompoundTag nbt, String name, Class<N> nbtType, Function<N, T> mapper) {
        HashMap<UUID, T> res = new HashMap<UUID, T>();
        ListTag uuidList = nbt.m_128437_(name + "Keys", 8);
        ListTag valuesList = (ListTag)nbt.m_128423_(name + "Values");
        if (uuidList.size() != valuesList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < uuidList.size(); ++i) {
            res.put(UUID.fromString(uuidList.get(i).m_7916_()), mapper.apply(valuesList.get(i)));
        }
        return res;
    }

    public static <K, V> void writeMap(CompoundTag tag, String key, Map<K, V> map, Function<K, String> getStringKey, Function<V, Tag> getNbtValue) {
        tag.m_128365_(key, (Tag)NBTHelper.serializeMap(map, getStringKey, getNbtValue));
    }

    public static <K, V> CompoundTag serializeMap(Map<K, V> map, Function<K, String> getStringKey, Function<V, Tag> getNbtValue) {
        CompoundTag mapNbt = new CompoundTag();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            mapNbt.m_128365_(getStringKey.apply(entry.getKey()), getNbtValue.apply(entry.getValue()));
        }
        return mapNbt;
    }

    public static <K, V> Optional<Map<K, V>> readMap(CompoundTag tag, String key, Function<String, K> getKey, BiFunction<String, Tag, Optional<V>> getValue) {
        CompoundTag mapNbt = tag.m_128469_(key);
        return Optional.of(NBTHelper.deserializeMap(mapNbt, getKey, getValue));
    }

    public static <K, V> Map<K, V> deserializeMap(CompoundTag mapNbt, Function<String, K> getKey, BiFunction<String, Tag, Optional<V>> getValue) {
        HashMap map = new HashMap();
        for (String tagName : mapNbt.m_128431_()) {
            getValue.apply(tagName, mapNbt.m_128423_(tagName)).ifPresent(value -> map.put(getKey.apply(tagName), value));
        }
        return map;
    }

    public static <T, N extends Tag> void writeMap(CompoundTag nbt, String name, Map<UUID, T> map, Class<N> nbtType, Function<T, N> mapper) {
        ListTag uuidList = new ListTag();
        ListTag valuesList = new ListTag();
        map.forEach((key, value) -> {
            uuidList.add((Object)StringTag.m_129297_((String)key.toString()));
            valuesList.add((Object)((Tag)mapper.apply(value)));
        });
        nbt.m_128365_(name + "Keys", (Tag)uuidList);
        nbt.m_128365_(name + "Values", (Tag)valuesList);
    }

    public static <T, N extends Tag> List<T> readList(CompoundTag nbt, String name, Class<N> nbtType, Function<N, T> mapper) {
        return NBTHelper.readCollection(nbt, name, nbtType, mapper, new ArrayList());
    }

    public static <T, N extends Tag> Set<T> readSet(CompoundTag nbt, String name, Class<N> nbtType, Function<N, T> mapper) {
        return NBTHelper.readCollection(nbt, name, nbtType, mapper, new HashSet());
    }

    public static <T, C extends Collection<T>, N extends Tag> C readCollection(CompoundTag nbt, String name, Class<N> nbtType, Function<N, T> mapper, C collection) {
        ListTag listNBT = (ListTag)nbt.m_128423_(name);
        if (listNBT == null) {
            return collection;
        }
        for (Tag inbt : listNBT) {
            collection.add(mapper.apply(inbt));
        }
        return collection;
    }

    public static <T, N extends Tag> List<T> readListOptional(CompoundTag nbt, String name, Class<N> nbtType, Function<N, Optional<T>> mapper) {
        return NBTHelper.readCollectionOptional(nbt, name, nbtType, mapper, new ArrayList());
    }

    public static <T, C extends Collection<T>, N extends Tag> C readCollectionOptional(CompoundTag nbt, String name, Class<N> nbtType, Function<N, Optional<T>> mapper, C collection) {
        ListTag listNBT = (ListTag)nbt.m_128423_(name);
        if (listNBT == null) {
            return collection;
        }
        for (Tag inbt : listNBT) {
            mapper.apply(inbt).ifPresent(collection::add);
        }
        return collection;
    }

    public static <T, N extends Tag> void writeCollection(CompoundTag nbt, String name, Collection<T> list, Class<N> nbtType, Function<T, N> mapper) {
        ListTag listNBT = new ListTag();
        list.forEach(item -> listNBT.add((Object)((Tag)mapper.apply(item))));
        nbt.m_128365_(name, (Tag)listNBT);
    }

    public static <T, N extends Tag> void writeCollectionOptional(CompoundTag nbt, String name, Collection<T> list, Class<N> nbtType, Function<T, Optional<N>> mapper) {
        ListTag listNBT = new ListTag();
        list.forEach(item -> ((Optional)mapper.apply(item)).ifPresent(arg_0 -> listNBT.add(arg_0)));
        nbt.m_128365_(name, (Tag)listNBT);
    }

    public static <T> void writeOptional(CompoundTag nbt, String key, @Nullable T object, BiConsumer<CompoundTag, T> writer) {
        nbt.m_128379_(key + "_present", object != null);
        if (object != null) {
            CompoundTag write = new CompoundTag();
            writer.accept(write, (CompoundTag)object);
            nbt.m_128365_(key, (Tag)write);
        }
    }

    @Nullable
    public static <T> T readOptional(CompoundTag nbt, String key, Function<CompoundTag, T> reader) {
        return NBTHelper.readOptional(nbt, key, reader, null);
    }

    @Nullable
    public static <T> T readOptional(CompoundTag nbt, String key, Function<CompoundTag, T> reader, T _default) {
        if (nbt.m_128471_(key + "_present")) {
            CompoundTag read = nbt.m_128469_(key);
            return reader.apply(read);
        }
        return _default;
    }

    public static ListTag serializeSimpleContainer(SimpleContainer ct) {
        ListTag list = new ListTag();
        for (int slot = 0; slot < ct.m_6643_(); ++slot) {
            ItemStack stack = ct.m_8020_(slot);
            if (stack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            tag.m_128365_("stack", (Tag)stack.serializeNBT());
            list.add((Object)tag);
        }
        return list;
    }

    public static void deserializeSimpleContainer(SimpleContainer ct, ListTag list) {
        ct.m_6211_();
        List<ItemStack> stacks = NBTHelper.deserializeSimpleContainer(list);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            if (stack.m_41619_()) continue;
            ct.m_6836_(i, stack);
        }
    }

    public static List<ItemStack> deserializeSimpleContainer(ListTag list) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            stacks.add(ItemStack.m_41712_((CompoundTag)list.m_128728_(i).m_128469_("stack")));
        }
        return stacks;
    }
}

