/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.server.command.EnumArgument;
import org.jetbrains.annotations.Nullable;

public enum SpectatorMode implements StringRepresentable
{
    OFF("off"),
    PLAYER("player"),
    FREEROAM("freeroam");

    private final String name;
    private static final Map<String, SpectatorMode> NAME_VALUES;

    private SpectatorMode(String name) {
        this.name = name;
    }

    public String m_7912_() {
        return this.name;
    }

    public static SpectatorMode fromName(String name) {
        return NAME_VALUES.getOrDefault(name, OFF);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (SpectatorMode value : SpectatorMode.values()) {
            builder.put((Object)value.m_7912_(), (Object)value);
        }
        NAME_VALUES = builder.build();
    }

    public static class GameRuleValue
    extends GameRules.Value<GameRuleValue> {
        private SpectatorMode mode = OFF;

        public GameRuleValue(GameRules.Type<GameRuleValue> type) {
            super(type);
        }

        public GameRuleValue(GameRules.Type<GameRuleValue> type, SpectatorMode mode) {
            super(type);
            this.mode = mode;
        }

        public static GameRules.Type<GameRuleValue> create(SpectatorMode defaultValue) {
            return new GameRules.Type(() -> EnumArgument.enumArgument(SpectatorMode.class), type -> new GameRuleValue((GameRules.Type<GameRuleValue>)type, defaultValue), (s, v) -> {}, (v, k, t) -> {});
        }

        protected void m_5528_(CommandContext<CommandSourceStack> context, String paramName) {
            this.mode = (SpectatorMode)((Object)context.getArgument(paramName, SpectatorMode.class));
        }

        protected void m_7377_(String value) {
            this.mode = SpectatorMode.fromName(value);
        }

        public String m_5831_() {
            return this.mode.m_7912_();
        }

        public int m_6855_() {
            return this.mode.m_7912_().hashCode();
        }

        protected GameRuleValue getSelf() {
            return this;
        }

        protected GameRuleValue copy() {
            return new GameRuleValue((GameRules.Type<GameRuleValue>)this.f_46360_, this.mode);
        }

        public void setFrom(GameRuleValue value, @Nullable MinecraftServer pServer) {
            this.mode = value.mode;
            this.m_46368_(pServer);
        }

        public void setMode(String value, @Nullable MinecraftServer server) {
            this.mode = SpectatorMode.fromName(value);
            this.m_46368_(server);
        }

        public void setMode(SpectatorMode value, @Nullable MinecraftServer server) {
            this.mode = value;
            this.m_46368_(server);
        }

        public SpectatorMode get() {
            return this.mode;
        }
    }
}

