/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.server.command.EnumArgument;
import org.jetbrains.annotations.Nullable;

public enum VaultExperience implements StringRepresentable
{
    POOR("poor", 0.1f),
    HALF("half", 0.5f),
    NORMAL("normal", 1.0f),
    DOUBLE("double", 2.0f),
    TRIPLE("triple", 3.0f);

    private final String name;
    private final float multiplier;
    private static final Map<String, VaultExperience> NAME_VALUES;

    private VaultExperience(String name, float multiplier) {
        this.name = name;
        this.multiplier = multiplier;
    }

    public String m_7912_() {
        return this.name;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public static VaultExperience fromName(String name) {
        return NAME_VALUES.getOrDefault(name, NORMAL);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (VaultExperience value : VaultExperience.values()) {
            builder.put((Object)value.m_7912_(), (Object)value);
        }
        NAME_VALUES = builder.build();
    }

    public static class GameRuleValue
    extends GameRules.Value<GameRuleValue> {
        private VaultExperience mode = NORMAL;

        public GameRuleValue(GameRules.Type<GameRuleValue> type) {
            super(type);
        }

        public GameRuleValue(GameRules.Type<GameRuleValue> type, VaultExperience mode) {
            super(type);
            this.mode = mode;
        }

        public static GameRules.Type<GameRuleValue> create(VaultExperience defaultValue) {
            return new GameRules.Type(() -> EnumArgument.enumArgument(VaultExperience.class), type -> new GameRuleValue((GameRules.Type<GameRuleValue>)type, defaultValue), (s, v) -> {}, (v, k, t) -> {});
        }

        protected void m_5528_(CommandContext<CommandSourceStack> context, String paramName) {
            this.mode = (VaultExperience)((Object)context.getArgument(paramName, VaultExperience.class));
        }

        protected void m_7377_(String value) {
            this.mode = VaultExperience.fromName(value);
        }

        public String m_5831_() {
            return this.mode.m_7912_();
        }

        public int m_6855_() {
            return this.mode.m_7912_().hashCode();
        }

        protected GameRuleValue getSelf() {
            return this;
        }

        protected GameRuleValue copy() {
            return new GameRuleValue((GameRules.Type<GameRuleValue>)this.f_46360_, this.mode);
        }

        public void setFrom(GameRuleValue value, @Nullable MinecraftServer pServer) {
            this.mode = value.mode;
            this.m_46368_(pServer);
        }

        public void setMode(String value, @Nullable MinecraftServer server) {
            this.mode = VaultExperience.fromName(value);
            this.m_46368_(server);
        }

        public void setMode(VaultExperience value, @Nullable MinecraftServer server) {
            this.mode = value;
            this.m_46368_(server);
        }

        public VaultExperience get() {
            return this.mode;
        }
    }
}

