/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.server.command.EnumArgument;
import org.jetbrains.annotations.Nullable;

public enum VaultPartyExpSharing implements StringRepresentable
{
    DISABLED("disabled", 0),
    HIGHEST("highest", 1),
    LOWEST("lowest", 2),
    AVERAGE("average", 3);

    private final String name;
    private final int id;
    private static final Map<String, VaultPartyExpSharing> NAME_VALUES;

    private VaultPartyExpSharing(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String m_7912_() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static VaultPartyExpSharing fromName(String name) {
        return NAME_VALUES.getOrDefault(name, DISABLED);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (VaultPartyExpSharing value : VaultPartyExpSharing.values()) {
            builder.put((Object)value.m_7912_(), (Object)value);
        }
        NAME_VALUES = builder.build();
    }

    public static class GameRuleValue
    extends GameRules.Value<GameRuleValue> {
        private VaultPartyExpSharing mode = DISABLED;

        public GameRuleValue(GameRules.Type<GameRuleValue> type) {
            super(type);
        }

        public GameRuleValue(GameRules.Type<GameRuleValue> type, VaultPartyExpSharing mode) {
            super(type);
            this.mode = mode;
        }

        public static GameRules.Type<GameRuleValue> create(VaultPartyExpSharing defaultValue) {
            return new GameRules.Type(() -> EnumArgument.enumArgument(VaultPartyExpSharing.class), type -> new GameRuleValue((GameRules.Type<GameRuleValue>)type, defaultValue), (s, v) -> {}, (v, k, t) -> {});
        }

        protected void m_5528_(CommandContext<CommandSourceStack> context, String paramName) {
            this.mode = (VaultPartyExpSharing)((Object)context.getArgument(paramName, VaultPartyExpSharing.class));
        }

        protected void m_7377_(String value) {
            this.mode = VaultPartyExpSharing.fromName(value);
        }

        public String m_5831_() {
            return this.mode.m_7912_();
        }

        public int m_6855_() {
            return this.mode.m_7912_().hashCode();
        }

        protected GameRuleValue getSelf() {
            return this;
        }

        protected GameRuleValue copy() {
            return new GameRuleValue((GameRules.Type<GameRuleValue>)this.f_46360_, this.mode);
        }

        public void setFrom(GameRuleValue value, @Nullable MinecraftServer pServer) {
            this.mode = value.mode;
            this.m_46368_(pServer);
        }

        public void setMode(String value, @Nullable MinecraftServer server) {
            this.mode = VaultPartyExpSharing.fromName(value);
            this.m_46368_(server);
        }

        public void setMode(VaultPartyExpSharing value, @Nullable MinecraftServer server) {
            this.mode = value;
            this.m_46368_(server);
        }

        public VaultPartyExpSharing get() {
            return this.mode;
        }
    }
}

