/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.mixin.AccessorWorldGenSettingsComponent;
import iskallia.vault.mixin.AccessorWorldPreset;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldGenSettingsComponent;
import net.minecraft.client.gui.screens.worldselection.WorldPreset;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.ForgeHooksClient;

public class WorldTypeHandler {
    public static Optional<WorldPreset> getCurrentPreset(WorldGenSettingsComponent component) {
        return ((AccessorWorldGenSettingsComponent)component).getPreset();
    }

    public static void setCurrentPreset(WorldGenSettingsComponent component, WorldPreset preset) {
        AccessorWorldGenSettingsComponent accessor = (AccessorWorldGenSettingsComponent)component;
        accessor.setPreset(Optional.of(preset));
        accessor.setSettings(preset.m_205485_(component.m_205473_(), accessor.getSettings().m_64619_(), accessor.getSettings().m_64657_(), accessor.getSettings().m_64660_()));
    }

    public static List<WorldPreset> getAvailablePresets() {
        return AccessorWorldPreset.getPresets().stream().filter(WorldPreset::m_170301_).collect(Collectors.toList());
    }

    public static List<WorldPreset> getAllPresets() {
        return AccessorWorldPreset.getPresets();
    }

    public static Screen createWorldTypeScreen(CreateWorldScreen parent, WorldGenSettingsComponent component) {
        return new WorldTypeScreen(parent, component);
    }

    private static class WorldTypeScreen
    extends Screen {
        private final CreateWorldScreen parent;
        private final WorldGenSettingsComponent component;

        public WorldTypeScreen(CreateWorldScreen parent, WorldGenSettingsComponent component) {
            super((Component)new TranslatableComponent("selectWorld.mapType"));
            this.parent = parent;
            this.component = component;
        }

        protected void m_7856_() {
            int centerX = this.f_96543_ / 2;
            int width = 310;
            Optional<WorldPreset> currentPreset = WorldTypeHandler.getCurrentPreset(this.component);
            this.m_142416_((GuiEventListener)CycleButton.m_168894_(WorldPreset::m_101523_).m_168952_(WorldTypeHandler.getAvailablePresets(), WorldTypeHandler.getAllPresets()).m_168948_((Object)currentPreset.orElse(WorldPreset.f_101506_)).m_168936_(centerX - width / 2, 100, width, 20, (Component)new TranslatableComponent("selectWorld.mapType"), (button, preset) -> WorldTypeHandler.setCurrentPreset(this.component, preset)));
            this.m_142416_((GuiEventListener)new Button(centerX - width / 2, 130, width, 20, (Component)new TranslatableComponent("selectWorld.customizeType"), button -> {
                WorldPreset.PresetEditor editor = AccessorWorldPreset.getEditor().get(WorldTypeHandler.getCurrentPreset(this.component).orElse(WorldPreset.f_101506_));
                editor = ForgeHooksClient.getPresetEditor(WorldTypeHandler.getCurrentPreset(this.component), (WorldPreset.PresetEditor)editor);
                if (editor != null) {
                    Minecraft.m_91087_().m_91152_(editor.m_101642_(this.parent, ((AccessorWorldGenSettingsComponent)this.component).getSettings()));
                }
            }));
            this.m_142416_((GuiEventListener)new Button(centerX - width / 2, this.f_96544_ - 28, width, 20, (Component)new TranslatableComponent("gui.done"), button -> Minecraft.m_91087_().m_91152_((Screen)this.parent)));
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            this.m_7333_(poseStack);
            WorldTypeScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)-1);
            super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }
}

