/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.block.entity.challenge.ChallengeManager;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.UpdateChallengeDataMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class ChallengeData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_Challenges";
    public static List<ChallengeManager> CLIENT = new ArrayList<ChallengeManager>();
    private final Map<UUID, ChallengeManager> managers = new HashMap<UUID, ChallengeManager>();

    public boolean contains(UUID uuid) {
        return this.managers.containsKey(uuid);
    }

    public void add(ServerLevel world, ChallengeManager manager) {
        this.managers.put(manager.getUuid(), manager);
        manager.onAttach(world);
    }

    public void remove(UUID uuid) {
        this.managers.remove(uuid);
    }

    public static boolean shouldRenderObjectives() {
        for (ChallengeManager manager : CLIENT) {
            if (manager.shouldRenderObjectives()) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        ChallengeData data = ChallengeData.get(server);
        data.managers.forEach((uuid, manager) -> {
            ServerLevel world = server.m_129880_(manager.dimension);
            if (world != null) {
                manager.onAttach(world);
            }
        });
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ChallengeData data = ChallengeData.get(server);
        HashSet<UUID> toUpdate = new HashSet<UUID>();
        data.managers.values().removeIf(manager -> {
            ServerLevel world = server.m_129880_(manager.dimension);
            if (world == null || manager.isDeleted()) {
                toUpdate.addAll(manager.players);
                manager.onRemove(server);
                manager.onDetach();
                return true;
            }
            return false;
        });
        for (ChallengeManager manager2 : data.managers.values()) {
            toUpdate.addAll(manager2.players);
        }
        for (UUID uuid : toUpdate) {
            ServerPlayer player = server.m_6846_().m_11259_(uuid);
            if (player == null) continue;
            data.sendUpdatesToClient(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        for (ChallengeManager manager : CLIENT) {
            manager.onRender(event.getMatrixStack(), event.getPartialTicks(), event.getWindow());
        }
    }

    public void sendUpdatesToClient(ServerPlayer player) {
        ArrayList<ChallengeManager> entries = new ArrayList<ChallengeManager>();
        this.managers.forEach((uuid, entry) -> {
            if (entry.players.contains(player.m_142081_())) {
                entries.add((ChallengeManager)entry);
            }
        });
        ModNetwork.CHANNEL.sendTo((Object)new UpdateChallengeDataMessage(entries), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        this.managers.values().forEach(manager -> Adapters.CHALLENGE_MANAGER.writeNbt(manager).ifPresent(arg_0 -> list.add(arg_0)));
        nbt.m_128365_("managers", (Tag)list);
        return nbt;
    }

    public boolean m_77764_() {
        return true;
    }

    private void read(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("managers", 10);
        this.managers.clear();
        for (Tag tag : list) {
            Adapters.CHALLENGE_MANAGER.readNbt(tag).ifPresent(manager -> this.managers.put(manager.getUuid(), (ChallengeManager)manager));
        }
    }

    private static ChallengeData load(CompoundTag nbt) {
        ChallengeData data = new ChallengeData();
        data.read(nbt);
        return data;
    }

    public static ChallengeData get(MinecraftServer server) {
        return (ChallengeData)server.m_129783_().m_8895_().m_164861_(ChallengeData::load, ChallengeData::new, DATA_NAME);
    }
}

