/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.transmog.DiscoveredEntriesMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CompanionVariantUnlockData
extends SavedData {
    private static final String DATA_NAME = "the_vault_CompanionVariantUnlocks";
    private final Map<UUID, Set<String>> unlockedVariants = new HashMap<UUID, Set<String>>();

    private CompanionVariantUnlockData() {
    }

    private CompanionVariantUnlockData(CompoundTag tag) {
        this.load(tag);
    }

    private static String normalize(String variantId) {
        return variantId == null ? "" : variantId.toLowerCase(Locale.ROOT);
    }

    private Set<String> getInternal(UUID playerId) {
        return this.unlockedVariants.computeIfAbsent(playerId, id -> new HashSet());
    }

    public boolean isUnlocked(UUID playerId, String variantId) {
        return this.getInternal(playerId).contains(CompanionVariantUnlockData.normalize(variantId));
    }

    public boolean unlock(UUID playerId, String variantId) {
        String normalized = CompanionVariantUnlockData.normalize(variantId);
        if (normalized.isEmpty()) {
            return false;
        }
        boolean added = this.getInternal(playerId).add(normalized);
        if (added) {
            this.m_77762_();
        }
        return added;
    }

    public boolean lock(UUID playerId, String variantId) {
        String normalized = CompanionVariantUnlockData.normalize(variantId);
        if (normalized.isEmpty()) {
            return false;
        }
        boolean removed = this.getInternal(playerId).remove(normalized);
        if (removed) {
            this.m_77762_();
        }
        return removed;
    }

    public Set<String> getUnlocked(UUID playerId) {
        return Collections.unmodifiableSet(new HashSet<String>(this.getInternal(playerId)));
    }

    public void syncTo(ServerPlayer player) {
        Set<ResourceLocation> payload = this.getUnlocked(player.m_142081_()).stream().map(VaultMod::id).collect(Collectors.toSet());
        DiscoveredEntriesMessage message = new DiscoveredEntriesMessage(DiscoveredEntriesMessage.Type.COMPANION_VARIANTS, payload);
        ModNetwork.CHANNEL.sendTo((Object)message, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void m_77760_(boolean dirty) {
        MinecraftServer server;
        super.m_77760_(dirty);
        if (dirty && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            server.m_6846_().m_11314_().forEach(this::syncTo);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        this.unlockedVariants.forEach((uuid, variants) -> {
            ListTag list = new ListTag();
            variants.forEach(variant -> list.add((Object)StringTag.m_129297_((String)variant)));
            tag.m_128365_(uuid.toString(), (Tag)list);
        });
        return tag;
    }

    private void load(CompoundTag tag) {
        this.unlockedVariants.clear();
        for (String key : tag.m_128431_()) {
            try {
                UUID uuid = UUID.fromString(key);
                HashSet<String> variants = new HashSet<String>();
                ListTag list = tag.m_128437_(key, 8);
                for (Tag entry : list) {
                    if (!(entry instanceof StringTag)) continue;
                    StringTag str = (StringTag)entry;
                    variants.add(CompanionVariantUnlockData.normalize(str.m_7916_()));
                }
                this.unlockedVariants.put(uuid, variants);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public static CompanionVariantUnlockData get(ServerLevel level) {
        return CompanionVariantUnlockData.get(level.m_142572_());
    }

    public static CompanionVariantUnlockData get(MinecraftServer server) {
        return (CompanionVariantUnlockData)server.m_129783_().m_8895_().m_164861_(CompanionVariantUnlockData::new, CompanionVariantUnlockData::new, DATA_NAME);
    }
}

