/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.transmog.DiscoveredEntriesMessage;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DiscoveredArtifactsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_DiscoveredArtifacts";
    protected Map<UUID, Set<Integer>> discoveredArtifacts = new HashMap<UUID, Set<Integer>>();

    private DiscoveredArtifactsData() {
    }

    private DiscoveredArtifactsData(CompoundTag tag) {
        this.load(tag);
    }

    public void discoverArtifactAndBroadcast(int artifactId, Player player) {
        if (this.discoverArtifact(player.m_142081_(), artifactId)) {
            this.broadcastDiscovery(artifactId, player);
        }
    }

    private void broadcastDiscovery(int artifactId, Player player) {
        MutableComponent message = new TextComponent("You have discovered ").m_130940_(ChatFormatting.GRAY);
        MutableComponent artifactNumberCmp = new TextComponent("Artifact #" + artifactId).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)16770048)));
        message.m_7220_((Component)artifactNumberCmp);
        player.m_5661_((Component)message, true);
    }

    public boolean discoverArtifact(UUID playerId, int artifactId) {
        Set artifacts = this.discoveredArtifacts.computeIfAbsent(playerId, id -> new HashSet());
        if (artifacts.add(artifactId)) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean hasDiscovered(Player player, int artifactId) {
        return this.hasDiscovered(player.m_142081_(), artifactId);
    }

    public boolean hasDiscovered(UUID playerId, int artifactId) {
        return this.discoveredArtifacts.getOrDefault(playerId, Collections.emptySet()).contains(artifactId);
    }

    public Set<Integer> getDiscoveredArtifacts(Player player) {
        return this.getDiscoveredArtifacts(player.m_142081_());
    }

    public Set<Integer> getDiscoveredArtifacts(UUID playerId) {
        return this.discoveredArtifacts.getOrDefault(playerId, Collections.emptySet());
    }

    public boolean discoveredAllArtifacts(Player player) {
        return this.discoveredAllArtifacts(player.m_142081_());
    }

    public boolean discoveredAllArtifacts(UUID playerId) {
        Set<Integer> discovered = this.getDiscoveredArtifacts(playerId);
        for (int i = 1; i <= 25; ++i) {
            if (discovered.contains(i)) continue;
            return false;
        }
        return true;
    }

    public void m_77760_(boolean dirty) {
        MinecraftServer srv;
        super.m_77760_(dirty);
        if (dirty && (srv = ServerLifecycleHooks.getCurrentServer()) != null) {
            srv.m_6846_().m_11314_().forEach(this::syncTo);
        }
    }

    private DiscoveredEntriesMessage getUpdatePacket(UUID playerId) {
        HashSet<ResourceLocation> artifactIds = new HashSet<ResourceLocation>();
        this.discoveredArtifacts.getOrDefault(playerId, Collections.emptySet()).forEach(id -> artifactIds.add(new ResourceLocation("the_vault", "artifact_" + id)));
        return new DiscoveredEntriesMessage(DiscoveredEntriesMessage.Type.ARTIFACTS, artifactIds);
    }

    public void syncTo(ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)this.getUpdatePacket(player.m_142081_()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void load(CompoundTag tag) {
        this.discoveredArtifacts.clear();
        ListTag playerArtifacts = tag.m_128437_("artifacts", 10);
        for (int i = 0; i < playerArtifacts.size(); ++i) {
            CompoundTag playerTag = playerArtifacts.m_128728_(i);
            UUID playerId = playerTag.m_128342_("player");
            Set<Integer> artifacts = NBTHelper.readSet(playerTag, "artifacts", IntTag.class, IntTag::m_7047_);
            this.discoveredArtifacts.put(playerId, artifacts);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        ListTag playerArtifacts = new ListTag();
        this.discoveredArtifacts.forEach((playerId, artifacts) -> {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("player", playerId);
            NBTHelper.writeCollection(playerTag, "artifacts", artifacts, IntTag.class, IntTag::m_128679_);
            playerArtifacts.add((Object)playerTag);
        });
        tag.m_128365_("artifacts", (Tag)playerArtifacts);
        return tag;
    }

    public static DiscoveredArtifactsData get(ServerLevel level) {
        return DiscoveredArtifactsData.get(level.m_142572_());
    }

    public static DiscoveredArtifactsData get(MinecraftServer server) {
        return (DiscoveredArtifactsData)server.m_129783_().m_8895_().m_164861_(DiscoveredArtifactsData::new, DiscoveredArtifactsData::new, DATA_NAME);
    }
}

