/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.gear.IdolItem;
import iskallia.vault.network.message.DiscoveredWorkbenchModifierCraftsMessage;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;

public class DiscoveredWorkbenchModifiersData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_DiscoveredWorkbenchModifiers";
    protected Map<UUID, Map<Item, Set<ResourceLocation>>> discoveredCrafts = new HashMap<UUID, Map<Item, Set<ResourceLocation>>>();

    private DiscoveredWorkbenchModifiersData() {
    }

    private DiscoveredWorkbenchModifiersData(CompoundTag tag) {
        this.load(tag);
    }

    public boolean compoundDiscoverWorkbenchCraft(ServerPlayer player, Item gearItem, ResourceLocation key) {
        if (gearItem instanceof IdolItem) {
            List<IdolItem> idols = List.of(ModItems.IDOL_TIMEKEEPER, ModItems.IDOL_BENEVOLENT, ModItems.IDOL_MALEVOLENCE, ModItems.IDOL_OMNISCIENT);
            boolean discovered = false;
            for (IdolItem idol : idols) {
                if (!this.discoverWorkbenchCraft(player, idol, key)) continue;
                discovered = true;
            }
            return discovered;
        }
        return this.discoverWorkbenchCraft(player, gearItem, key);
    }

    private boolean discoverWorkbenchCraft(ServerPlayer player, Item gearItem, ResourceLocation key) {
        Set craftKeys = this.discoveredCrafts.computeIfAbsent(player.m_142081_(), id -> new LinkedHashMap()).computeIfAbsent(gearItem, item -> new HashSet());
        if (craftKeys.add(key)) {
            this.m_77762_();
            this.syncTo(player);
            return true;
        }
        return false;
    }

    public boolean hasDiscoveredCraft(Player player, Item gearItem, ResourceLocation key) {
        return this.discoveredCrafts.getOrDefault(player.m_142081_(), Collections.emptyMap()).getOrDefault(gearItem, Collections.emptySet()).contains(key);
    }

    private DiscoveredWorkbenchModifierCraftsMessage getUpdatePacket(UUID playerId) {
        return new DiscoveredWorkbenchModifierCraftsMessage(this.discoveredCrafts.getOrDefault(playerId, Collections.emptyMap()));
    }

    public void resetCrafts(UUID playerId) {
        this.discoveredCrafts.remove(playerId);
        this.m_77762_();
    }

    public Map<UUID, Map<Item, Set<ResourceLocation>>> getDiscoveredCrafts() {
        return this.discoveredCrafts;
    }

    public void syncTo(ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)this.getUpdatePacket(player.m_142081_()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag playerTrinkets = new ListTag();
        this.discoveredCrafts.forEach((playerId, itemCrafts) -> {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("player", playerId);
            CompoundTag craftsTag = new CompoundTag();
            itemCrafts.forEach((item, keys) -> NBTHelper.writeCollection(craftsTag, item.getRegistryName().toString(), keys, StringTag.class, key -> StringTag.m_129297_((String)key.toString())));
            playerTag.m_128365_("itemCrafts", (Tag)craftsTag);
            playerTrinkets.add((Object)playerTag);
        });
        tag.m_128365_("crafts", (Tag)playerTrinkets);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.discoveredCrafts.clear();
        ListTag playerTrinkets = tag.m_128437_("crafts", 10);
        for (int i = 0; i < playerTrinkets.size(); ++i) {
            CompoundTag playerTag = playerTrinkets.m_128728_(i);
            UUID playerId = playerTag.m_128342_("player");
            CompoundTag craftsTag = playerTag.m_128469_("itemCrafts");
            HashSet<ResourceLocation> idolCrafts = new HashSet<ResourceLocation>();
            LinkedHashMap<Item, Set<ResourceLocation>> itemCrafts = new LinkedHashMap<Item, Set<ResourceLocation>>();
            for (String itemKey : craftsTag.m_128431_()) {
                Item item;
                ResourceLocation key = ResourceLocation.m_135820_((String)itemKey);
                if (key == null || (item = (Item)ForgeRegistries.ITEMS.getValue(key)) == null) continue;
                Set<ResourceLocation> crafts = NBTHelper.readSet(craftsTag, itemKey, StringTag.class, strTag -> new ResourceLocation(strTag.m_7916_()));
                itemCrafts.put(item, crafts);
                if (!(item instanceof IdolItem)) continue;
                idolCrafts.addAll(crafts);
            }
            if (!idolCrafts.isEmpty()) {
                itemCrafts.put(ModItems.IDOL_TIMEKEEPER, idolCrafts);
                itemCrafts.put(ModItems.IDOL_BENEVOLENT, idolCrafts);
                itemCrafts.put(ModItems.IDOL_MALEVOLENCE, idolCrafts);
                itemCrafts.put(ModItems.IDOL_OMNISCIENT, idolCrafts);
            }
            this.discoveredCrafts.put(playerId, itemCrafts);
        }
    }

    public static DiscoveredWorkbenchModifiersData get(ServerLevel level) {
        return DiscoveredWorkbenchModifiersData.get(level.m_142572_());
    }

    public static DiscoveredWorkbenchModifiersData get(MinecraftServer server) {
        return (DiscoveredWorkbenchModifiersData)server.m_129783_().m_8895_().m_164861_(DiscoveredWorkbenchModifiersData::new, DiscoveredWorkbenchModifiersData::new, DATA_NAME);
    }
}

