/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.discoverylogic.DiscoveryGoalsState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;

public class DiscoveryGoalStatesData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_DiscoveryGoalStates";
    private final Map<UUID, DiscoveryGoalsState> playerMap = new HashMap<UUID, DiscoveryGoalsState>();

    public DiscoveryGoalsState getState(ServerPlayer serverPlayer) {
        return this.getState(serverPlayer.m_142081_());
    }

    public DiscoveryGoalsState getState(UUID playerUuid) {
        return this.playerMap.computeIfAbsent(playerUuid, DiscoveryGoalsState::new);
    }

    public static DiscoveryGoalStatesData create(CompoundTag nbt) {
        DiscoveryGoalStatesData data = new DiscoveryGoalStatesData();
        data.load(nbt);
        return data;
    }

    public void load(@Nonnull CompoundTag nbt) {
        ListTag playerList = nbt.m_128437_("PlayersList", 8);
        ListTag talentList = nbt.m_128437_("StatesList", 10);
        if (playerList.size() != talentList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.getState(playerUUID).deserializeNBT(talentList.m_128728_(i));
        }
        this.m_77762_();
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag stateList = new ListTag();
        this.playerMap.forEach((uuid, state) -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            stateList.add((Object)state.serializeNBT());
        });
        nbt.m_128365_("PlayersList", (Tag)playerList);
        nbt.m_128365_("StatesList", (Tag)stateList);
        return nbt;
    }

    public static DiscoveryGoalStatesData get(ServerLevel world) {
        return (DiscoveryGoalStatesData)world.m_142572_().m_129783_().m_8895_().m_164861_(DiscoveryGoalStatesData::create, DiscoveryGoalStatesData::new, DATA_NAME);
    }
}

