/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.util.MiscUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class DollLootData
extends SavedData {
    private static final String DATA_NAME_PREFIX = "vaultdolls/";
    private static final String LOOT_STACKS_TAG = "lootStacks";
    private List<ItemStack> lootStacks = new ArrayList<ItemStack>();

    public static DollLootData get(ServerLevel level, UUID dollId) {
        return (DollLootData)level.m_142572_().m_129783_().m_8895_().m_164861_(DollLootData::create, DollLootData::new, DATA_NAME_PREFIX + dollId.toString());
    }

    public void addLoot(ItemStack lootStack) {
        MiscUtils.mergeItemStack(this.lootStacks, lootStack);
        this.m_77762_();
    }

    public static DollLootData create(CompoundTag tag) {
        DollLootData data = new DollLootData();
        data.load(tag);
        return data;
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag tag) {
        if (!this.lootStacks.isEmpty()) {
            tag.m_128365_(LOOT_STACKS_TAG, (Tag)this.serializeStacks(this.lootStacks));
        }
        return tag;
    }

    public void m_77757_(File file) {
        file.getParentFile().mkdirs();
        super.m_77757_(file);
    }

    public void load(CompoundTag tag) {
        this.lootStacks.clear();
        if (tag.m_128441_(LOOT_STACKS_TAG)) {
            this.deserializeStacks(tag.m_128437_(LOOT_STACKS_TAG, 10));
        }
    }

    private ListTag serializeStacks(List<ItemStack> lootStacks) {
        ListTag lootStacksNbt = new ListTag();
        lootStacks.forEach(stack -> lootStacksNbt.add((Object)stack.m_41739_(new CompoundTag())));
        return lootStacksNbt;
    }

    private void deserializeStacks(ListTag itemsNbt) {
        this.lootStacks.clear();
        itemsNbt.forEach(nbt -> {
            CompoundTag itemNbt = (CompoundTag)nbt;
            this.lootStacks.add(ItemStack.m_41712_((CompoundTag)itemNbt));
        });
    }

    public List<ItemStack> getLoot() {
        return this.lootStacks;
    }

    public void clearLoot() {
        this.lootStacks.clear();
        this.m_77762_();
    }
}

