/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.crystal.layout.preset.StructurePreset;
import iskallia.vault.network.message.UpdateParadoxDataMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ParadoxCrystalData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_CrystalParadox";
    public static ParadoxCrystalData CLIENT = new ParadoxCrystalData();
    private final Map<UUID, Entry> entries = new HashMap<UUID, Entry>();

    private ParadoxCrystalData() {
    }

    private ParadoxCrystalData(CompoundTag tag) {
        this.load(tag);
    }

    public boolean m_77764_() {
        return true;
    }

    public Entry getOrCreate(UUID uuid) {
        return this.entries.computeIfAbsent(uuid, uuid1 -> new Entry());
    }

    public void putAll(Map<UUID, Entry> entries) {
        this.entries.putAll(entries);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModNetwork.CHANNEL.sendTo((Object)new UpdateParadoxDataMessage(ParadoxCrystalData.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).entries), player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        HashMap<UUID, Entry> changed = new HashMap<UUID, Entry>();
        ParadoxCrystalData.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).entries.forEach((uuid, entry) -> {
            if (entry.changed) {
                changed.put((UUID)uuid, (Entry)entry);
                entry.changed = false;
            }
        });
        if (!changed.isEmpty()) {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateParadoxDataMessage(changed));
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        this.entries.forEach((id, entry) -> entry.writeNbt().ifPresent(tag -> nbt.m_128365_(id.toString(), (Tag)tag)));
        return nbt;
    }

    public void load(CompoundTag nbt) {
        this.entries.clear();
        nbt.m_128431_().forEach(id -> {
            CompoundTag tag = nbt.m_128469_(id);
            Entry entry = new Entry();
            entry.readNbt(tag);
            this.entries.put(UUID.fromString(id), entry);
        });
    }

    public static Entry getEntry(UUID uuid) {
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            return ParadoxCrystalData.get(ServerLifecycleHooks.getCurrentServer()).getOrCreate(uuid);
        }
        return CLIENT.getOrCreate(uuid);
    }

    public static ParadoxCrystalData get(ServerLevel level) {
        return ParadoxCrystalData.get(level.m_142572_());
    }

    public static ParadoxCrystalData get(MinecraftServer server) {
        return (ParadoxCrystalData)server.m_129783_().m_8895_().m_164861_(ParadoxCrystalData::new, ParadoxCrystalData::new, DATA_NAME);
    }

    public static class Entry
    implements ISerializable<CompoundTag, JsonObject> {
        public long seed;
        public long unlockTime;
        public StructurePreset preset;
        public List<VaultModifierStack> modifiers = new ArrayList<VaultModifierStack>();
        public boolean changed;

        public Entry() {
            this.reset();
        }

        public void reset() {
            this.seed = new Random().nextLong();
            this.unlockTime = 0L;
            this.preset = null;
            this.modifiers.clear();
            this.changed = true;
        }

        public void mergeModifiers(List<VaultModifierStack> modifiers) {
            LinkedHashMap map = new LinkedHashMap();
            for (VaultModifierStack vaultModifierStack : this.modifiers) {
                map.put(vaultModifierStack.getModifier(), map.getOrDefault(vaultModifierStack.getModifier(), 0) + vaultModifierStack.getSize());
            }
            for (VaultModifierStack vaultModifierStack : modifiers) {
                map.put(vaultModifierStack.getModifier(), map.getOrDefault(vaultModifierStack.getModifier(), 0) + vaultModifierStack.getSize());
            }
            this.modifiers.clear();
            for (Map.Entry entry : map.entrySet()) {
                this.modifiers.add(VaultModifierStack.of((VaultModifier)entry.getKey(), (Integer)entry.getValue()));
            }
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.LONG.writeNbt(this.seed).ifPresent(tag -> nbt.m_128365_("seed", tag));
            Adapters.LONG.writeNbt(this.unlockTime).ifPresent(tag -> nbt.m_128365_("unlock_time", tag));
            Adapters.STRUCTURE_PRESET.writeNbt(this.preset).ifPresent(tag -> nbt.m_128365_("preset", (Tag)tag));
            ListTag list = new ListTag();
            for (VaultModifierStack modifier : this.modifiers) {
                list.add((Object)modifier.serializeNBT());
            }
            nbt.m_128365_("modifiers", (Tag)list);
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.seed = Adapters.LONG.readNbt(nbt.m_128423_("seed")).orElse(0L);
            this.unlockTime = Adapters.LONG.readNbt(nbt.m_128423_("unlock_time")).orElse(0L);
            this.preset = Adapters.STRUCTURE_PRESET.readNbt((CompoundTag)nbt.m_128423_("preset")).orElse(null);
            this.modifiers = new ArrayList<VaultModifierStack>();
            ListTag list = nbt.m_128437_("modifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.modifiers.add(VaultModifierStack.of(list.m_128728_(i)));
            }
        }
    }
}

