/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.world.generator.layout.ArchitectRoomEntry;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.template.data.DirectTemplateEntry;
import iskallia.vault.core.world.template.data.TemplatePool;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.item.crystal.layout.preset.PoolKeyTemplatePreset;
import iskallia.vault.item.crystal.layout.preset.PoolTemplatePreset;
import iskallia.vault.item.crystal.layout.preset.StructurePreset;
import iskallia.vault.item.crystal.layout.preset.TemplatePreset;
import iskallia.vault.item.data.InscriptionData;
import iskallia.vault.network.message.UpdatePersonalVaultDataMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PersonalVaultData
extends SavedData {
    private static final String DATA_NAME = "the_vault_PersonalVault";
    public static PersonalVaultData CLIENT = new PersonalVaultData();
    private final Map<UUID, Entry> entries = new HashMap<UUID, Entry>();

    private PersonalVaultData() {
    }

    private PersonalVaultData(CompoundTag tag) {
        this.load(tag);
    }

    public boolean m_77764_() {
        return true;
    }

    public Entry getOrCreate(UUID playerId) {
        return this.entries.computeIfAbsent(playerId, id -> new Entry());
    }

    public void putAll(Map<UUID, Entry> data) {
        this.entries.putAll(data);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PersonalVaultData serverData = PersonalVaultData.get(player2.m_20194_());
        UpdatePersonalVaultDataMessage message = new UpdatePersonalVaultDataMessage(serverData.entries);
        ModNetwork.CHANNEL.sendTo((Object)message, player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        PersonalVaultData serverData = PersonalVaultData.get(PersonalVaultData.getCurrentServer());
        HashMap<UUID, Entry> updatedEntries = new HashMap<UUID, Entry>();
        for (Map.Entry<UUID, Entry> e : serverData.entries.entrySet()) {
            Entry entry = e.getValue();
            if (!entry.changed) continue;
            updatedEntries.put(e.getKey(), entry);
            entry.changed = false;
        }
        if (!updatedEntries.isEmpty()) {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdatePersonalVaultDataMessage(updatedEntries));
        }
    }

    private static MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        for (Map.Entry<UUID, Entry> e : this.entries.entrySet()) {
            e.getValue().writeNbt().ifPresent(nbt -> tag.m_128365_(((UUID)e.getKey()).toString(), (Tag)nbt));
        }
        return tag;
    }

    private void load(CompoundTag tag) {
        this.entries.clear();
        for (String key : tag.m_128431_()) {
            CompoundTag entryTag = tag.m_128469_(key);
            Entry entry = new Entry();
            entry.readNbt(entryTag);
            this.entries.put(UUID.fromString(key), entry);
        }
    }

    public static Entry getEntry(UUID playerId) {
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            return PersonalVaultData.get(PersonalVaultData.getCurrentServer()).getOrCreate(playerId);
        }
        return CLIENT.getOrCreate(playerId);
    }

    public static PersonalVaultData get(ServerLevel level) {
        return PersonalVaultData.get(level.m_142572_());
    }

    public static PersonalVaultData get(MinecraftServer server) {
        return (PersonalVaultData)server.m_129783_().m_8895_().m_164861_(PersonalVaultData::new, PersonalVaultData::new, DATA_NAME);
    }

    public static class Entry
    implements ISerializable<CompoundTag, JsonObject> {
        public static final int GRID_SIZE = 9;
        public static final int TOTAL_SLOTS = 81;
        public static final int CENTER_SLOT = 40;
        public static final int CATALYST_COLS = 9;
        public static final int CATALYST_ROWS = 7;
        public static final int CATALYST_SLOTS = 63;
        public static final int CRAFTING_SLOTS = 3;
        public static final byte LOCKED = 0;
        public static final byte UNLOCKED = 1;
        public static final byte FILLED = 2;
        public static final byte ROCK = 3;
        public long unlockTime;
        public boolean changed;
        private byte[] slotStatus;
        public StructurePreset preset;
        private List<ItemStack> infusedCatalysts;
        private Map<Integer, ItemStack> slotItems;
        public List<VaultModifierStack> modifiers = new ArrayList<VaultModifierStack>();

        public int getUnlockedSlots() {
            int unlocked = 0;
            for (byte status : this.slotStatus) {
                if (status != 1) continue;
                ++unlocked;
            }
            return unlocked;
        }

        public Entry() {
            this.infusedCatalysts = new ArrayList<ItemStack>(Collections.nCopies(63, ItemStack.f_41583_));
            this.slotStatus = new byte[81];
            this.slotItems = new HashMap<Integer, ItemStack>();
            this.reset();
        }

        public void reset() {
            this.unlockTime = 0L;
            this.preset = new StructurePreset();
            this.infusedCatalysts = new ArrayList<ItemStack>(Collections.nCopies(63, ItemStack.f_41583_));
            this.slotItems = new HashMap<Integer, ItemStack>();
            Arrays.fill(this.slotStatus, (byte)0);
            this.slotStatus[40] = 3;
            this.unlockAdjacentSlots();
            this.initializeStartRoom();
            this.changed = true;
        }

        public Map<Integer, ItemStack> getSlotItems() {
            return this.slotItems;
        }

        public SlotStatus getSlotStatus(int slot) {
            if (slot < 0 || slot >= 81) {
                return null;
            }
            return SlotStatus.values()[this.slotStatus[slot]];
        }

        private void unlockAdjacentSlots() {
            int row = 4;
            int col = 4;
            for (int dr = -1; dr <= 1; ++dr) {
                for (int dc = -1; dc <= 1; ++dc) {
                    int newCol;
                    int newRow;
                    if (dr == 0 && dc == 0 || !this.isValidSlot(newRow = row + dr, newCol = col + dc)) continue;
                    int adjacentSlot = newRow * 9 + newCol;
                    this.slotStatus[adjacentSlot] = 1;
                }
            }
        }

        private void initializeStartRoom() {
            this.preset = new StructurePreset().put(RegionPos.ORIGIN, new PoolTemplatePreset(VaultLayout.PieceType.ROOM, (TemplatePool)new TemplatePool().addLeaf(new DirectTemplateEntry(VaultMod.id("vault/starts/personal_vault_start1"), List.of(VaultMod.id("raw/objective_placeholder"))), 1.0)));
        }

        private boolean isValidSlot(int row, int col) {
            return row >= 0 && col >= 0 && row < 9 && col < 9;
        }

        public OptionalInt findFirstValidSlot() {
            for (int i = 0; i < 81; ++i) {
                if (this.slotStatus[i] != 1) continue;
                int row = i / 9;
                int col = i % 9;
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    int neighbour;
                    int nc;
                    int nr = row + dir.m_122431_();
                    if (!this.isValidSlot(nr, nc = col + dir.m_122429_()) || this.slotStatus[neighbour = nr * 9 + nc] != 2 && this.slotStatus[neighbour] != 3) continue;
                    return OptionalInt.of(i);
                }
            }
            return OptionalInt.empty();
        }

        public RegionPos slotToRegionPos(int slot) {
            int row = slot / 9;
            int col = slot % 9;
            int centerRow = 4;
            int centerCol = 4;
            int gridX = col - centerCol;
            int gridZ = row - centerRow;
            int tunnelSpan = 1;
            int x = gridX * (tunnelSpan + 1);
            int z = gridZ * (tunnelSpan + 1);
            return RegionPos.of(x, z, 0, 0);
        }

        public int regionPosToSlot(int x, int z) {
            int centerRow = 4;
            int centerCol = 4;
            int row = centerRow + z;
            int col = centerCol + x;
            return row * 9 + col;
        }

        public boolean canUnlockSlot(int slot) {
            if (slot < 0 || slot >= 81) {
                return false;
            }
            if (this.slotStatus[slot] != 0) {
                return false;
            }
            int row = slot / 9;
            int col = slot % 9;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                int neighborSlot;
                int neighborCol;
                int neighborRow = row + dir.m_122431_();
                if (!this.isValidSlot(neighborRow, neighborCol = col + dir.m_122429_()) || this.slotStatus[neighborSlot = neighborRow * 9 + neighborCol] <= 0) continue;
                return true;
            }
            return false;
        }

        public boolean hasAdjacentRoomOrRock(int slot) {
            if (slot < 0 || slot >= 81) {
                return false;
            }
            int row = slot / 9;
            int col = slot % 9;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                int neighbor;
                int nc;
                int nr = row + dir.m_122431_();
                if (!this.isValidSlot(nr, nc = col + dir.m_122429_()) || this.slotStatus[neighbor = nr * 9 + nc] != 2 && this.slotStatus[neighbor] != 3) continue;
                return true;
            }
            return false;
        }

        public boolean unlockSlot(int slot) {
            if (!this.canUnlockSlot(slot)) {
                return false;
            }
            this.slotStatus[slot] = 1;
            this.changed = true;
            return true;
        }

        private int getNeighborSlot(int slot, Direction dir) {
            int row = slot / 9;
            int col = slot % 9;
            int newRow = row + dir.m_122431_();
            int newCol = col + dir.m_122429_();
            if (newRow < 0 || newRow >= 9 || newCol < 0 || newCol >= 9) {
                return -1;
            }
            return newRow * 9 + newCol;
        }

        public boolean placeInscription(int slot, ItemStack stack) {
            if (slot < 0 || slot >= 81) {
                return false;
            }
            if (this.slotStatus[slot] != 1) {
                return false;
            }
            this.slotItems.put(slot, stack);
            this.slotStatus[slot] = 2;
            if (!InscriptionData.from(stack).getModifiers().isEmpty()) {
                this.calculateModifiers();
            }
            this.changed = true;
            TemplatePreset tpl = this.createTemplatePresetFromInscription(stack);
            if (tpl != null) {
                RegionPos roomPos = this.slotToRegionPos(slot);
                this.preset.put(roomPos, tpl);
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    RegionPos tunnelPos;
                    int neighborSlot = this.getNeighborSlot(slot, dir);
                    if (neighborSlot < 0 || this.slotStatus[neighborSlot] != 2 && this.slotStatus[neighborSlot] != 3) continue;
                    RegionPos neighborPos = this.slotToRegionPos(neighborSlot);
                    if (dir.m_122434_() == Direction.Axis.X) {
                        tunnelPos = RegionPos.of((roomPos.m_123341_() + neighborPos.m_123341_()) / 2, roomPos.m_123343_(), 0, 0);
                        this.preset.put(tunnelPos, new PoolKeyTemplatePreset(VaultLayout.PieceType.TUNNEL_X, VaultRegistry.TEMPLATE_POOL.getKey(VaultMod.id("vault/tunnels/default"))));
                        continue;
                    }
                    tunnelPos = RegionPos.of(roomPos.m_123341_(), (roomPos.m_123343_() + neighborPos.m_123343_()) / 2, 0, 0);
                    this.preset.put(tunnelPos, new PoolKeyTemplatePreset(VaultLayout.PieceType.TUNNEL_Z, VaultRegistry.TEMPLATE_POOL.getKey(VaultMod.id("vault/tunnels/default"))));
                }
            }
            return true;
        }

        public boolean removeInscription(int slot) {
            if (!this.slotItems.containsKey(slot)) {
                return false;
            }
            this.slotItems.remove(slot);
            this.slotStatus[slot] = 1;
            RegionPos roomPos = this.slotToRegionPos(slot);
            this.preset.remove(roomPos);
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                RegionPos tunnelPos = dir.m_122434_() == Direction.Axis.X ? RegionPos.of(roomPos.m_123341_() + dir.m_122429_(), roomPos.m_123343_(), 0, 0) : RegionPos.of(roomPos.m_123341_(), roomPos.m_123343_() + dir.m_122431_(), 0, 0);
                if (!this.preset.contains(tunnelPos)) continue;
                this.preset.getAll().remove((Object)tunnelPos);
            }
            this.calculateModifiers();
            this.changed = true;
            return true;
        }

        public void generateStructurePreset() {
            StructurePreset newPreset = new StructurePreset();
            this.initializeStartRoom();
            for (Map.Entry<Integer, ItemStack> entry : this.slotItems.entrySet()) {
                TemplatePreset tpl = this.createTemplatePresetFromInscription(entry.getValue());
                if (tpl == null) continue;
                newPreset.put(this.slotToRegionPos(entry.getKey()), tpl);
            }
            this.preset = newPreset;
            this.changed = true;
        }

        public ItemStack getInfusedCatalyst(int slot) {
            if (slot < 0 || slot >= 63) {
                return ItemStack.f_41583_;
            }
            return this.infusedCatalysts.get(slot);
        }

        public List<ItemStack> getInfusedCatalysts() {
            return this.infusedCatalysts;
        }

        public void placeInfusedCatalyst(int slot, ItemStack stack) {
            if (slot < 0 || slot >= 63) {
                return;
            }
            this.infusedCatalysts.set(slot, stack);
            this.calculateModifiers();
        }

        public void removeInfusedCatalyst(int slot) {
            if (slot < 0 || slot >= 63) {
                return;
            }
            this.infusedCatalysts.set(slot, ItemStack.f_41583_);
            this.calculateModifiers();
        }

        private void calculateModifiers() {
            LinkedHashMap counts = new LinkedHashMap();
            for (ItemStack catalyst : this.infusedCatalysts) {
                if (catalyst.m_41619_()) continue;
                for (ResourceLocation id : InfusedCatalystItem.getModifiers(catalyst)) {
                    Object mod = VaultModifierRegistry.get(id);
                    if (mod == null) continue;
                    counts.merge(mod, 1, Integer::sum);
                }
            }
            for (ItemStack inscription : this.slotItems.values()) {
                if (inscription.m_41619_()) continue;
                InscriptionData data = InscriptionData.from(inscription);
                for (ResourceLocation id : data.getModifiers()) {
                    Object mod = VaultModifierRegistry.get(id);
                    if (mod == null) continue;
                    counts.merge(mod, 1, Integer::sum);
                }
            }
            this.modifiers.clear();
            counts.entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).forEach(e -> this.modifiers.add(VaultModifierStack.of((VaultModifier)e.getKey(), (Integer)e.getValue())));
            this.changed = true;
        }

        public TemplatePreset createTemplatePresetFromInscription(ItemStack stack) {
            if (stack.m_41619_()) {
                return null;
            }
            InscriptionData data = InscriptionData.from(stack);
            if (data.getEntries().isEmpty()) {
                return null;
            }
            for (InscriptionData.Entry entry : data.getEntries()) {
                ArchitectRoomEntry room = entry.toRoomEntry();
                if (room.has(ArchitectRoomEntry.POOL)) {
                    ResourceLocation poolId = room.get(ArchitectRoomEntry.POOL);
                    return new PoolKeyTemplatePreset(VaultLayout.PieceType.ROOM, VaultRegistry.TEMPLATE_POOL.getKey(poolId));
                }
                if (!room.has(ArchitectRoomEntry.TYPE)) continue;
                return new PoolKeyTemplatePreset(VaultLayout.PieceType.ROOM, VaultRegistry.TEMPLATE_POOL.getKey(switch (room.get(ArchitectRoomEntry.TYPE)) {
                    case ArchitectRoomEntry.Type.COMMON -> VaultMod.id("vault/rooms/common/default");
                    case ArchitectRoomEntry.Type.CHALLENGE -> VaultMod.id("vault/rooms/challenge/default");
                    default -> VaultMod.id("vault/rooms/omega/default");
                }));
            }
            return null;
        }

        public static int getRing(int slot) {
            int row = slot / 9;
            int col = slot % 9;
            int centerRow = 4;
            int centerCol = 4;
            int rowDist = Math.abs(row - centerRow);
            int colDist = Math.abs(col - centerCol);
            if (rowDist <= 1 && colDist <= 1) {
                return 0;
            }
            int maxDist = Math.max(rowDist, colDist);
            return maxDist - 1;
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("unlockTime", this.unlockTime);
            Adapters.STRUCTURE_PRESET.writeNbt(this.preset).ifPresent(p -> tag.m_128365_("preset", (Tag)p));
            ListTag catTag = new ListTag();
            for (ItemStack st : this.infusedCatalysts) {
                CompoundTag ct = new CompoundTag();
                st.m_41739_(ct);
                catTag.add((Object)ct);
            }
            tag.m_128365_("infusedCatalysts", (Tag)catTag);
            CompoundTag statusTag = new CompoundTag();
            for (int i = 0; i < this.slotStatus.length; ++i) {
                if (this.slotStatus[i] == 0) continue;
                statusTag.m_128344_(String.valueOf(i), this.slotStatus[i]);
            }
            tag.m_128365_("slotStatus", (Tag)statusTag);
            CompoundTag itemsTag = new CompoundTag();
            for (Map.Entry<Integer, ItemStack> e : this.slotItems.entrySet()) {
                CompoundTag itemTag = new CompoundTag();
                e.getValue().m_41739_(itemTag);
                itemsTag.m_128365_(String.valueOf(e.getKey()), (Tag)itemTag);
            }
            tag.m_128365_("slotItems", (Tag)itemsTag);
            return Optional.of(tag);
        }

        @Override
        public void readNbt(CompoundTag tag) {
            this.unlockTime = tag.m_128454_("unlockTime");
            this.preset = Adapters.STRUCTURE_PRESET.readNbt(tag.m_128469_("preset")).orElse(new StructurePreset());
            this.infusedCatalysts = new ArrayList<ItemStack>(Collections.nCopies(63, ItemStack.f_41583_));
            ListTag catTag = tag.m_128437_("infusedCatalysts", 10);
            for (int i = 0; i < Math.min(catTag.size(), 63); ++i) {
                this.infusedCatalysts.set(i, ItemStack.m_41712_((CompoundTag)catTag.m_128728_(i)));
            }
            this.slotStatus = new byte[81];
            CompoundTag statusTag = tag.m_128469_("slotStatus");
            for (String key : statusTag.m_128431_()) {
                this.slotStatus[Integer.parseInt((String)key)] = statusTag.m_128445_(key);
            }
            this.slotItems.clear();
            CompoundTag itemsTag = tag.m_128469_("slotItems");
            for (String key : itemsTag.m_128431_()) {
                CompoundTag itemTag = itemsTag.m_128469_(key);
                this.slotItems.put(Integer.parseInt(key), ItemStack.m_41712_((CompoundTag)itemTag));
            }
            this.changed = false;
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject());
        }

        @Override
        public void readJson(JsonObject json) {
        }

        public static enum SlotStatus {
            LOCKED,
            UNLOCKED,
            FILLED,
            ROCK;

        }
    }
}

