/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerAliasData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerAlias";
    private final Map<String, String> aliases = new HashMap<String, String>();

    public void putAlias(String from, String to) {
        this.aliases.put(from.toLowerCase(), to);
        this.m_77762_();
    }

    @Nullable
    public String getAlias(String from) {
        return this.aliases.get(from.toLowerCase());
    }

    private static PlayerAliasData create(CompoundTag tag) {
        PlayerAliasData data = new PlayerAliasData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag tag) {
        this.aliases.clear();
        ListTag aliasList = tag.m_128437_("aliases", 10);
        for (int i = 0; i < aliasList.size(); ++i) {
            CompoundTag aliasEntry = aliasList.m_128728_(i);
            String from = aliasEntry.m_128461_("from");
            String to = aliasEntry.m_128461_("to");
            this.aliases.put(from.toLowerCase(), to);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag aliasList = new ListTag();
        this.aliases.forEach((from, to) -> {
            CompoundTag aliasEntry = new CompoundTag();
            aliasEntry.m_128359_("from", from);
            aliasEntry.m_128359_("to", to);
            aliasList.add((Object)aliasEntry);
        });
        tag.m_128365_("aliases", (Tag)aliasList);
        return tag;
    }

    public static PlayerAliasData get(ServerLevel world) {
        return (PlayerAliasData)world.m_142572_().m_129783_().m_8895_().m_164861_(PlayerAliasData::create, PlayerAliasData::new, DATA_NAME);
    }

    @Nonnull
    public static String applyAlias(ServerPlayer player, String gifter) {
        return PlayerAliasData.applyAlias(player, gifter, false);
    }

    @Nonnull
    public static String applyAlias(ServerPlayer player, String gifter, boolean silent) {
        String alias = PlayerAliasData.get(player.m_183503_()).getAlias(gifter);
        if (alias != null) {
            if (!silent && !alias.equalsIgnoreCase(gifter)) {
                player.m_6352_((Component)new TextComponent("Alias: Renamed " + gifter + " to " + alias).m_130940_(ChatFormatting.GRAY), Util.f_137441_);
            }
            return alias;
        }
        return gifter;
    }
}

