/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.config.CompanionsConfig;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.CompanionParticleTrailItem;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.item.gear.TemporalShardItem;
import iskallia.vault.network.message.UpdateCompanionDataMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.CommanderPrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerCompanionData
extends SavedData {
    private static final String NAME = "the_vault_PlayerCompanions";
    public static PlayerCompanionData CLIENT = new PlayerCompanionData();
    private final Map<UUID, CompanionData> companionMap = new HashMap<UUID, CompanionData>();

    public void putAll(Map<UUID, CompanionData> data) {
        this.companionMap.putAll(data);
    }

    public static PlayerCompanionData get(MinecraftServer server) {
        if (server == null) {
            return CLIENT;
        }
        return (PlayerCompanionData)server.m_129783_().m_8895_().m_164861_(PlayerCompanionData::new, PlayerCompanionData::new, NAME);
    }

    private PlayerCompanionData() {
    }

    private PlayerCompanionData(CompoundTag tag) {
        this.load(tag);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag all = new CompoundTag();
        this.companionMap.forEach((uuid, data) -> all.m_128365_(uuid.toString(), (Tag)data.save()));
        tag.m_128365_("data", (Tag)all);
        return tag;
    }

    private void load(CompoundTag tag) {
        this.companionMap.clear();
        CompoundTag all = tag.m_128469_("data");
        for (String key : all.m_128431_()) {
            UUID uuid = UUID.fromString(key);
            CompanionData data = new CompanionData(uuid);
            data.load(all.m_128469_(key));
            this.companionMap.put(uuid, data);
        }
    }

    public CompanionData getOrCreate(UUID id) {
        return this.companionMap.computeIfAbsent(id, __ -> new CompanionData(id));
    }

    public Optional<CompanionData> get(UUID id) {
        return Optional.ofNullable(this.companionMap.get(id));
    }

    public void sync(UUID id) {
        CompanionData data = this.companionMap.get(id);
        if (data != null) {
            this.sync(Map.of(id, data));
        }
    }

    public void sync(Map<UUID, CompanionData> data) {
        if (!data.isEmpty()) {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateCompanionDataMessage(data));
        }
    }

    public boolean m_77764_() {
        return true;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerCompanionData serverData = PlayerCompanionData.get(player2.m_20194_());
        HashMap<UUID, CompanionData> playerCompanions = new HashMap<UUID, CompanionData>();
        serverData.companionMap.entrySet().stream().filter(entry -> player2.m_142081_().equals(((CompanionData)entry.getValue()).getOwner())).forEach(entry -> playerCompanions.put((UUID)entry.getKey(), (CompanionData)entry.getValue()));
        if (!playerCompanions.isEmpty()) {
            UpdateCompanionDataMessage message = new UpdateCompanionDataMessage(playerCompanions);
            ModNetwork.CHANNEL.sendTo((Object)message, player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private static MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static class CompanionData {
        private final UUID companionId;
        private UUID lastTemporalVault;
        private String name;
        private String type;
        private UUID owner;
        private CompanionSeries series;
        private int level;
        private int xp;
        private int hearts;
        private int maxHearts;
        private int baseCooldownMinutes;
        private long cooldownExpiry;
        private ResourceLocation temporalModifier;
        private int relicSlots;
        private final Map<Integer, Pair<Integer, List<ResourceLocation>>> relics = new HashMap<Integer, Pair<Integer, List<ResourceLocation>>>();
        private int cosmeticSlots;
        private final Map<Integer, Integer> cosmeticColours = new HashMap<Integer, Integer>();
        private final Map<Integer, CompanionParticleTrailItem.TrailType> cosmeticTrailTypes = new HashMap<Integer, CompanionParticleTrailItem.TrailType>();
        private CompoundTag spawnData;
        private int vaultRuns;
        private String hatchedDate;
        private boolean active = false;

        public CompanionData(UUID companionId) {
            this.companionId = companionId;
            this.series = CompanionSeries.LEGEND;
            this.level = 1;
            this.hearts = 1;
            this.maxHearts = 1;
            this.relicSlots = 0;
            this.cosmeticSlots = 0;
            this.cosmeticColours.clear();
            this.cosmeticTrailTypes.clear();
            this.vaultRuns = 0;
            this.hatchedDate = "";
            this.active = false;
        }

        private void markUpdated() {
            MinecraftServer server = PlayerCompanionData.getCurrentServer();
            if (server != null) {
                PlayerCompanionData data = PlayerCompanionData.get(server);
                data.m_77762_();
                data.sync(Map.of(this.companionId, this));
            }
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("name", this.name != null ? this.name : "");
            tag.m_128359_("type", this.type != null ? this.type : "");
            tag.m_128359_("owner", this.owner != null ? this.owner.toString() : "");
            tag.m_128359_("series", this.series.name());
            tag.m_128405_("level", this.level);
            tag.m_128405_("xp", this.xp);
            tag.m_128405_("hearts", this.hearts);
            tag.m_128405_("maxHearts", this.maxHearts);
            tag.m_128405_("baseCooldown", this.baseCooldownMinutes);
            tag.m_128356_("cooldownExpiry", this.cooldownExpiry);
            tag.m_128359_("lastTemporalVault", this.lastTemporalVault != null ? this.lastTemporalVault.toString() : "");
            tag.m_128359_("temporal", this.temporalModifier != null ? this.temporalModifier.toString() : "");
            tag.m_128359_("id", this.companionId.toString());
            tag.m_128405_("vaultRuns", this.vaultRuns);
            tag.m_128359_("hatchedDate", this.hatchedDate != null ? this.hatchedDate : "");
            tag.m_128405_("relicSlots", this.relicSlots);
            tag.m_128405_("cosmeticSlots", this.cosmeticSlots);
            CompoundTag relicTag = new CompoundTag();
            for (Map.Entry<Integer, Pair<Integer, List<ResourceLocation>>> entry : this.relics.entrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                Pair<Integer, List<ResourceLocation>> pair = entry.getValue();
                ListTag list = new ListTag();
                for (ResourceLocation id : (List)pair.getSecond()) {
                    list.add((Object)StringTag.m_129297_((String)id.toString()));
                }
                compoundTag.m_128405_("model", ((Integer)pair.getFirst()).intValue());
                compoundTag.m_128365_("modifiers", (Tag)list);
                relicTag.m_128365_(String.valueOf(entry.getKey()), (Tag)compoundTag);
            }
            tag.m_128365_("relics", (Tag)relicTag);
            CompoundTag cosmeticTag = new CompoundTag();
            for (Map.Entry<Integer, Integer> entry : this.cosmeticColours.entrySet()) {
                cosmeticTag.m_128405_(String.valueOf(entry.getKey()), entry.getValue().intValue());
            }
            tag.m_128365_("cosmeticColours", (Tag)cosmeticTag);
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<Integer, CompanionParticleTrailItem.TrailType> entry : this.cosmeticTrailTypes.entrySet()) {
                compoundTag.m_128405_(String.valueOf(entry.getKey()), entry.getValue().ordinal());
            }
            tag.m_128365_("cosmeticTrailTypes", (Tag)compoundTag);
            if (this.spawnData != null) {
                tag.m_128365_("spawnData", (Tag)this.spawnData);
            }
            return tag;
        }

        public void load(CompoundTag tag) {
            block22: {
                this.name = tag.m_128461_("name");
                this.type = tag.m_128461_("type");
                String ownerStr = tag.m_128461_("owner");
                try {
                    this.owner = ownerStr.isEmpty() ? null : UUID.fromString(ownerStr);
                }
                catch (IllegalArgumentException e) {
                    this.owner = null;
                    MinecraftServer server = PlayerCompanionData.getCurrentServer();
                    if (server == null) break block22;
                    server.m_129927_().m_10996_(ownerStr).ifPresent(profile -> {
                        this.owner = profile.getId();
                    });
                }
            }
            try {
                this.series = CompanionSeries.valueOf(tag.m_128461_("series"));
            }
            catch (IllegalArgumentException e) {
                this.series = CompanionSeries.LEGEND;
            }
            this.level = tag.m_128451_("level");
            this.xp = tag.m_128451_("xp");
            this.hearts = tag.m_128451_("hearts");
            this.maxHearts = tag.m_128451_("maxHearts");
            this.vaultRuns = tag.m_128451_("vaultRuns");
            this.hatchedDate = tag.m_128461_("hatchedDate");
            this.baseCooldownMinutes = tag.m_128451_("baseCooldown");
            this.cooldownExpiry = tag.m_128454_("cooldownExpiry");
            String lastVault = tag.m_128461_("lastTemporalVault");
            this.lastTemporalVault = lastVault.isEmpty() ? null : UUID.fromString(lastVault);
            UUID tagId = UUID.fromString(tag.m_128461_("id"));
            if (!tagId.equals(this.companionId)) {
                throw new IllegalStateException("CompanionData ID mismatch: " + String.valueOf(tagId) + " vs " + String.valueOf(this.companionId));
            }
            String tmp = tag.m_128461_("temporal");
            if (!tmp.isEmpty()) {
                this.temporalModifier = ResourceLocation.m_135820_((String)tmp);
            }
            this.relicSlots = tag.m_128451_("relicSlots");
            this.cosmeticSlots = tag.m_128441_("cosmeticSlots") ? tag.m_128451_("cosmeticSlots") : 1;
            this.relics.clear();
            CompoundTag relicTag = tag.m_128469_("relics");
            for (String key : relicTag.m_128431_()) {
                try {
                    int slot = Integer.parseInt(key);
                    CompoundTag relicData = relicTag.m_128469_(key);
                    int model = relicData.m_128451_("model");
                    ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
                    ListTag list = relicData.m_128437_("modifiers", 8);
                    for (Tag t : list) {
                        StringTag str;
                        ResourceLocation id;
                        if (!(t instanceof StringTag) || (id = ResourceLocation.m_135820_((String)(str = (StringTag)t).m_7916_())) == null) continue;
                        ids.add(id);
                    }
                    if (ids.isEmpty()) continue;
                    this.relics.put(slot, (Pair<Integer, List<ResourceLocation>>)Pair.of((Object)model, ids));
                }
                catch (NumberFormatException slot) {}
            }
            this.cosmeticColours.clear();
            this.cosmeticTrailTypes.clear();
            if (tag.m_128441_("cosmeticColours")) {
                CompoundTag cosmeticTag = tag.m_128469_("cosmeticColours");
                for (String key : cosmeticTag.m_128431_()) {
                    try {
                        int slot = Integer.parseInt(key);
                        this.cosmeticColours.put(slot, cosmeticTag.m_128451_(key));
                    }
                    catch (NumberFormatException slot) {}
                }
            } else if (tag.m_128441_("trailColour")) {
                this.cosmeticColours.put(0, tag.m_128451_("trailColour"));
                if (this.cosmeticSlots < 1) {
                    this.cosmeticSlots = 1;
                }
            }
            if (tag.m_128441_("cosmeticTrailTypes")) {
                CompoundTag typeTag = tag.m_128469_("cosmeticTrailTypes");
                for (String key : typeTag.m_128431_()) {
                    try {
                        int slot = Integer.parseInt(key);
                        int ord = typeTag.m_128451_(key);
                        if (ord < 0 || ord >= CompanionParticleTrailItem.TrailType.values().length) continue;
                        this.cosmeticTrailTypes.put(slot, CompanionParticleTrailItem.TrailType.values()[ord]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (tag.m_128441_("spawnData")) {
                this.spawnData = tag.m_128469_("spawnData");
            }
        }

        public void addXP(int xpToAdd) {
            CompanionsConfig.CompanionLevelMeta levelMeta;
            int requiredXPForNextLevel;
            if (this.level >= ModConfigs.COMPANIONS.getMaxLevel()) {
                this.xp = 0;
                return;
            }
            int newXP = this.xp + xpToAdd;
            newXP = Math.round((float)newXP * ModConfigs.COMPANIONS.getExpMultiplier());
            while (this.level < ModConfigs.COMPANIONS.getMaxLevel() && newXP >= (requiredXPForNextLevel = (levelMeta = ModConfigs.COMPANIONS.getLevelMeta(this.level)).getTnl())) {
                newXP -= requiredXPForNextLevel;
                ++this.level;
                ArrayList<String> rewards = new ArrayList<String>();
                if (this.level == 2 || this.level == 5 || this.level == 8 || this.level == 10) {
                    this.addRelicSlot();
                    rewards.add("Relic Slot");
                }
                if (this.level == 3 || this.level == 6 || this.level == 10) {
                    this.addCosmeticSlot();
                    rewards.add("Particle Slot");
                }
                if (this.level == 4 || this.level == 7 || this.level == 9 || this.level == 10) {
                    this.addMaxHeart(1);
                    rewards.add("Heart");
                }
                if (rewards.isEmpty()) continue;
                this.notifyOwnerLevelUp(String.join((CharSequence)" and ", rewards));
            }
            if (this.level >= ModConfigs.COMPANIONS.getMaxLevel()) {
                newXP = 0;
            }
            this.xp = newXP;
            this.markUpdated();
        }

        private void notifyOwnerLevelUp(String reward) {
            MinecraftServer server = PlayerCompanionData.getCurrentServer();
            if (server == null || this.owner == null) {
                return;
            }
            ServerPlayer player = server.m_6846_().m_11259_(this.owner);
            if (player == null) {
                return;
            }
            String compName = this.name == null || this.name.isEmpty() ? "Companion" : this.name;
            MutableComponent msg = new TextComponent("<" + compName + "> ").m_7220_((Component)new TextComponent("I have levelled up! I gained an extra ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(reward).m_130940_(ChatFormatting.GOLD));
            player.m_6352_((Component)msg, player.m_142081_());
        }

        public int getXPRequiredForNextLevel() {
            if (this.level >= ModConfigs.COMPANIONS.getMaxLevel()) {
                return 0;
            }
            CompanionsConfig.CompanionLevelMeta levelMeta = ModConfigs.COMPANIONS.getLevelMeta(this.level);
            return levelMeta.getTnl();
        }

        public long getCooldownMs() {
            long now = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli();
            return Math.max(0L, this.cooldownExpiry - now);
        }

        public long getCooldownExpiry() {
            return this.cooldownExpiry;
        }

        public int getCooldownSeconds() {
            return (int)(this.getCooldownMs() / 1000L);
        }

        public boolean isOnCooldown() {
            return this.getCooldownMs() > 0L;
        }

        public void startCooldown() {
            if (this.isOnCooldown()) {
                return;
            }
            int base = this.baseCooldownMinutes;
            float multiplier = ModConfigs.COMPANIONS.getCooldownMultiplier();
            int extra = Math.round((float)base * multiplier * (float)(this.level - 1));
            int total = base + extra;
            this.setCooldown(total);
        }

        public void setCooldown(int minutes) {
            long cooldownMs = (long)minutes * 60L * 1000L;
            this.cooldownExpiry = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli() + cooldownMs;
            this.markUpdated();
        }

        public void addCooldownTime(int seconds) {
            this.cooldownExpiry += (long)seconds * 1000L;
            this.markUpdated();
        }

        public void reduceCooldown(int seconds) {
            this.cooldownExpiry -= (long)seconds * 1000L;
            long now = ZonedDateTime.now().withZoneSameInstant(ZoneId.of("UTC")).toInstant().toEpochMilli();
            if (this.cooldownExpiry < now) {
                this.cooldownExpiry = now;
            }
            this.markUpdated();
        }

        public void addRelicSlot() {
            if (this.relicSlots < 4) {
                ++this.relicSlots;
                this.markUpdated();
            }
        }

        public void setRelic(int slot, int model, List<ResourceLocation> ids) {
            if (slot < 0 || slot >= this.relicSlots) {
                return;
            }
            if (ids == null || ids.isEmpty()) {
                this.relics.remove(slot);
            } else {
                this.relics.put(slot, (Pair<Integer, List<ResourceLocation>>)Pair.of((Object)model, new ArrayList<ResourceLocation>(ids)));
            }
            this.markUpdated();
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setRelic(int slot, int model, ResourceLocation id) {
            this.setRelic(slot, model, id == null ? Collections.emptyList() : List.of(id));
        }

        public Optional<Pair<Integer, List<ResourceLocation>>> getRelic(int slot) {
            return Optional.ofNullable(this.relics.get(slot));
        }

        public Map<Integer, Pair<Integer, List<ResourceLocation>>> getAllRelics() {
            return new HashMap<Integer, Pair<Integer, List<ResourceLocation>>>(this.relics);
        }

        public void clearAllRelics() {
            this.relics.clear();
            this.markUpdated();
        }

        public void activateTemporalModifier(ServerPlayer player, Vault vault) {
            if (this.temporalModifier != null) {
                Object vaultModifier = VaultModifierRegistry.get(this.temporalModifier);
                if (vaultModifier != null) {
                    int duration = this.getTemporalDuration();
                    for (CommanderPrestigePower power : PrestigeHelper.getPrestige((Player)player).getAll(CommanderPrestigePower.class, Skill::isUnlocked)) {
                        duration = Math.round((float)duration * power.getDurationMultiplier());
                    }
                    int finalDuration = duration;
                    vault.get(Vault.MODIFIERS).addModifier((VaultModifier<?>)vaultModifier, 1, true, JavaRandom.ofNanoTime(), context -> {
                        if (finalDuration > 0) {
                            context.set(ModifierContext.TICKS_LEFT, finalDuration);
                        }
                    });
                    MutableComponent text = new TextComponent("").m_7220_(player.m_5446_()).m_7220_((Component)new TextComponent("'s Companion added ").m_130940_(ChatFormatting.GRAY)).m_7220_(((VaultModifier)vaultModifier).getChatDisplayNameComponent(1)).m_7220_((Component)new TextComponent(" for ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(TemporalShardItem.formatTime(duration / 20))).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
                    for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                        listener.getPlayer().ifPresent(arg_0 -> CompanionData.lambda$activateTemporalModifier$2(listener, (Component)text, arg_0));
                    }
                }
            } else {
                this.setTemporalModifier(CompanionData.getRandomTemporalModifier().getId());
                this.activateTemporalModifier(player, vault);
            }
        }

        public int getTemporalDuration() {
            return ModConfigs.COMPANIONS.getTemporalModifierTime(this.level);
        }

        private static VaultModifier<?> getRandomTemporalModifier() {
            return (VaultModifier)ModConfigs.VAULT_MODIFIER_POOLS.getRandom(ResourceLocation.m_135820_((String)"the_vault:companion_temporal"), 0, JavaRandom.ofNanoTime()).stream().findFirst().orElseThrow(() -> new IllegalStateException("No temporal modifier found"));
        }

        private static VaultModifier<?> getRandomModifier() {
            return (VaultModifier)ModConfigs.VAULT_MODIFIER_POOLS.getRandom(ResourceLocation.m_135820_((String)"the_vault:companion_modifiers"), 0, JavaRandom.ofNanoTime()).stream().findFirst().orElseThrow(() -> new IllegalStateException("No modifier found"));
        }

        public UUID getCompanionId() {
            return this.companionId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            this.markUpdated();
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
            this.markUpdated();
        }

        public UUID getOwner() {
            return this.owner;
        }

        public void setOwner(UUID owner) {
            this.owner = owner;
            this.markUpdated();
        }

        public CompanionSeries getSeries() {
            return this.series;
        }

        public void setSeries(CompanionSeries series) {
            this.series = series;
            this.markUpdated();
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
            this.markUpdated();
        }

        public int getXp() {
            return this.xp;
        }

        public void setXp(int xp) {
            this.xp = xp;
            this.markUpdated();
        }

        public int getHearts() {
            return this.hearts;
        }

        public void setHearts(int hearts) {
            this.hearts = hearts;
            this.markUpdated();
        }

        public void setMaxHearts(int maxHearts) {
            this.maxHearts = maxHearts;
            this.hearts = maxHearts;
            this.markUpdated();
        }

        public void addMaxHeart(int maxHearts) {
            this.maxHearts += maxHearts;
            this.hearts += maxHearts;
            this.markUpdated();
        }

        public int getMaxHearts() {
            return this.maxHearts;
        }

        public int getBaseCooldownMinutes() {
            return this.baseCooldownMinutes;
        }

        public int getVaultRuns() {
            return this.vaultRuns;
        }

        public void incrementVaultRuns() {
            ++this.vaultRuns;
            this.markUpdated();
        }

        public void setVaultRuns(int runs) {
            this.vaultRuns = runs;
            this.markUpdated();
        }

        public String getHatchedDate() {
            return this.hatchedDate;
        }

        public void setHatchedDate(String date) {
            this.hatchedDate = date;
            this.markUpdated();
        }

        public int getRelicSlots() {
            return this.relicSlots;
        }

        public void setBaseCooldownMinutes(int minutes) {
            this.baseCooldownMinutes = minutes;
            this.markUpdated();
        }

        public void setRelicSlots(int slots) {
            this.relicSlots = slots;
            this.markUpdated();
        }

        public int getTrailColour() {
            return this.cosmeticColours.getOrDefault(0, -1);
        }

        public void setTrailColour(int colour) {
            this.setCosmeticColour(0, colour);
        }

        public void setCosmeticColour(int slot, int colour) {
            if (slot < 0 || slot >= this.cosmeticSlots) {
                return;
            }
            if (colour == -1) {
                this.cosmeticColours.remove(slot);
            } else {
                this.cosmeticColours.put(slot, colour);
            }
            this.markUpdated();
        }

        public void setCosmeticTrailType(int slot, CompanionParticleTrailItem.TrailType type) {
            if (slot < 0 || slot >= this.cosmeticSlots) {
                return;
            }
            if (type == null) {
                this.cosmeticTrailTypes.remove(slot);
            } else {
                this.cosmeticTrailTypes.put(slot, type);
            }
            this.markUpdated();
        }

        public int getCosmeticColour(int slot) {
            return this.cosmeticColours.getOrDefault(slot, -1);
        }

        public CompanionParticleTrailItem.TrailType getCosmeticTrailType(int slot) {
            return this.cosmeticTrailTypes.getOrDefault(slot, CompanionParticleTrailItem.TrailType.DUST);
        }

        public List<Integer> getAllCosmeticColours() {
            ArrayList<Integer> cols = new ArrayList<Integer>();
            for (int i = 0; i < this.cosmeticSlots; ++i) {
                int c = this.getCosmeticColour(i);
                cols.add(c);
            }
            return cols;
        }

        public List<CompanionParticleTrailItem.TrailType> getAllCosmeticTrailTypes() {
            ArrayList<CompanionParticleTrailItem.TrailType> list = new ArrayList<CompanionParticleTrailItem.TrailType>();
            for (int i = 0; i < this.cosmeticSlots; ++i) {
                list.add(this.getCosmeticTrailType(i));
            }
            return list;
        }

        public int getCosmeticSlots() {
            return this.cosmeticSlots;
        }

        public void addCosmeticSlot() {
            if (this.cosmeticSlots < 3) {
                ++this.cosmeticSlots;
                this.markUpdated();
            }
        }

        public void setCosmeticSlots(int slots) {
            this.cosmeticSlots = slots;
            this.markUpdated();
        }

        public Optional<ResourceLocation> getTemporalModifier() {
            return Optional.ofNullable(this.temporalModifier);
        }

        public void setTemporalModifier(ResourceLocation id) {
            this.temporalModifier = id;
            this.markUpdated();
        }

        public CompoundTag getSpawnData() {
            return this.spawnData == null ? null : this.spawnData.m_6426_();
        }

        public void setSpawnData(CompoundTag tag) {
            this.spawnData = tag == null ? null : tag.m_6426_();
            this.markUpdated();
        }

        public Map<Integer, Pair<Integer, List<ResourceLocation>>> getAllRelicMap() {
            return new HashMap<Integer, Pair<Integer, List<ResourceLocation>>>(this.relics);
        }

        public boolean hasUsedTemporalIn(UUID vaultId) {
            return vaultId != null && vaultId.equals(this.lastTemporalVault);
        }

        public void markTemporalUsed(UUID vaultId) {
            this.lastTemporalVault = vaultId;
            this.markUpdated();
        }

        private static /* synthetic */ void lambda$activateTemporalModifier$2(Listener listener, Component text, ServerPlayer other) {
            if (!(listener instanceof Runner)) {
                return;
            }
            other.m_5661_(text, false);
        }
    }
}

