/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.nbt.VMapNBT;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class PlayerCompanionEggData
extends SavedData {
    private static final String DATA_NAME = "the_vault_CompanionEggData";
    private final VMapNBT<UUID, EggHuntInfo> playerMap = VMapNBT.ofUUID(EggHuntInfo::new);

    public PlayerCompanionEggData() {
    }

    public PlayerCompanionEggData(CompoundTag tag) {
        this.load(tag);
    }

    public Optional<RunRecord> findRecord(UUID player, UUID vaultId) {
        return this.get(player).getHistory().stream().filter(r -> vaultId.equals(r.vaultId)).findFirst();
    }

    public void markCollected(UUID player, UUID vaultId) {
        EggHuntInfo info = this.get(player);
        Optional<RunRecord> existing = info.getHistory().stream().filter(r -> vaultId.equals(r.vaultId)).findFirst();
        if (existing.isPresent()) {
            existing.get().setStatus(EggStatus.COLLECTED);
        } else {
            info.addRecord(vaultId, EggStatus.COLLECTED);
        }
        info.resetDiscount();
        this.m_77762_();
    }

    public EggHuntInfo get(UUID uuid) {
        return (EggHuntInfo)this.playerMap.computeIfAbsent(uuid, k -> new EggHuntInfo());
    }

    public void load(CompoundTag tag) {
        this.playerMap.deserializeNBT(tag.m_128437_("PlayerMap", 10));
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128365_("PlayerMap", (Tag)this.playerMap.serializeNBT());
        return tag;
    }

    public static PlayerCompanionEggData get() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return (PlayerCompanionEggData)server.m_129783_().m_8895_().m_164861_(PlayerCompanionEggData::new, PlayerCompanionEggData::new, DATA_NAME);
    }

    public static class EggHuntInfo
    implements INBTSerializable<CompoundTag> {
        private float discount;
        private final VListNBT<RunRecord, CompoundTag> history = VListNBT.of(RunRecord::new);

        public float getDiscount() {
            return this.discount;
        }

        public void resetDiscount() {
            this.discount = 0.0f;
        }

        public void increaseDiscount() {
            this.discount = Math.min(0.75f, this.discount + 0.1f);
        }

        public void addRecord(UUID vaultId, EggStatus status) {
            this.history.add(new RunRecord(vaultId, status));
            if (this.history.size() > 50) {
                this.history.remove(0);
            }
        }

        public List<RunRecord> getHistory() {
            return Collections.unmodifiableList(this.history);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("discount", this.discount);
            tag.m_128365_("history", (Tag)this.history.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.discount = nbt.m_128457_("discount");
            this.history.deserializeNBT(nbt.m_128437_("history", 10));
        }
    }

    public static class RunRecord
    implements INBTSerializable<CompoundTag> {
        private UUID vaultId;
        private EggStatus status;
        private long timestamp;

        public RunRecord() {
        }

        public RunRecord(UUID vaultId, EggStatus status) {
            this.vaultId = vaultId;
            this.status = status;
            this.timestamp = System.currentTimeMillis() / 1000L;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.vaultId != null) {
                tag.m_128362_("vaultId", this.vaultId);
            }
            tag.m_128359_("status", this.status.name());
            tag.m_128356_("timestamp", this.timestamp);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            if (nbt.m_128403_("vaultId")) {
                this.vaultId = nbt.m_128342_("vaultId");
            }
            this.status = EggStatus.valueOf(nbt.m_128461_("status"));
            this.timestamp = nbt.m_128454_("timestamp");
            if (this.vaultId == null) {
                VaultMod.LOGGER.warn("Deserialized RunRecord with null vaultId - Something went wrong!!!");
            }
        }

        public void setStatus(EggStatus status) {
            this.status = status;
        }
    }

    public static enum EggStatus {
        OFFERED,
        COLLECTED,
        NONE;

    }
}

