/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.PatreonDisplaySettingsMessage;
import iskallia.vault.www.patreon.PatreonTier;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerPatreonDisplayData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerPatreonDisplayData";
    private final Map<UUID, PatreonDisplay> patreonDisplay = new HashMap<UUID, PatreonDisplay>();

    public PlayerPatreonDisplayData() {
    }

    private PlayerPatreonDisplayData(CompoundTag tag) {
        this.load(tag);
    }

    @Nullable
    public PatreonDisplay getDisplaySettings(UUID uuid) {
        return this.patreonDisplay.getOrDefault(uuid, null);
    }

    public void setDisplaySettings(UUID uuid, PatreonDisplay patreonDisplay) {
        this.patreonDisplay.put(uuid, patreonDisplay);
        this.m_77762_();
    }

    public boolean hasSettings(UUID uuid) {
        return this.patreonDisplay.containsKey(uuid);
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag listTag = new ListTag();
        for (Map.Entry<UUID, PatreonDisplay> entry : this.patreonDisplay.entrySet()) {
            CompoundTag compoundTag1 = new CompoundTag();
            compoundTag1.m_128359_("uuid", entry.getKey().toString());
            compoundTag1.m_128365_("data", (Tag)entry.getValue().serializeNBT());
            listTag.add((Object)compoundTag1);
        }
        compoundTag.m_128365_("patreonDisplay", (Tag)listTag);
        return compoundTag;
    }

    public void load(CompoundTag compoundTag) {
        this.patreonDisplay.clear();
        ListTag listTag = compoundTag.m_128437_("patreonDisplay", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag1 = listTag.m_128728_(i);
            UUID uuid = UUID.fromString(compoundTag1.m_128461_("uuid"));
            PatreonDisplay data = PatreonDisplay.fromNbt(compoundTag1.m_128469_("data"));
            this.patreonDisplay.put(uuid, data);
        }
    }

    public static PlayerPatreonDisplayData get(ServerLevel world) {
        return PlayerPatreonDisplayData.get(world.m_142572_());
    }

    public static PlayerPatreonDisplayData get(MinecraftServer server) {
        return (PlayerPatreonDisplayData)server.m_129783_().m_8895_().m_164861_(PlayerPatreonDisplayData::new, PlayerPatreonDisplayData::new, DATA_NAME);
    }

    public void syncTo(ServerPlayer player) {
        PatreonDisplay playerData = this.getDisplaySettings(player.m_142081_());
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PatreonDisplaySettingsMessage.S2C(playerData));
    }

    public void m_77760_(boolean dirty) {
        MinecraftServer srv;
        super.m_77760_(dirty);
        if (dirty && (srv = ServerLifecycleHooks.getCurrentServer()) != null) {
            srv.m_6846_().m_11314_().forEach(this::syncTo);
        }
    }

    public static class PatreonDisplay
    implements INBTSerializable<CompoundTag> {
        @Nullable
        public PatreonTier displayTier;
        public boolean enableColour;
        public boolean enableEmblem;

        public PatreonDisplay(@Nullable PatreonTier displayTier, boolean enableColour, boolean enableEmblem) {
            this.displayTier = displayTier;
            this.enableColour = enableColour;
            this.enableEmblem = enableEmblem;
        }

        @Nullable
        public PatreonTier getDisplayTier() {
            return this.displayTier;
        }

        public void setDisplayTier(@Nullable PatreonTier displayTier) {
            this.displayTier = displayTier;
        }

        public boolean isColourEnabled() {
            return this.enableColour;
        }

        public void enableColour(boolean enableColour) {
            this.enableColour = enableColour;
        }

        public boolean isEmblemEnabled() {
            return this.enableEmblem;
        }

        public void enableEmblem(boolean enableEmblem) {
            this.enableEmblem = enableEmblem;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.displayTier != null) {
                tag.m_128405_("displayTier", this.displayTier.ordinal());
            }
            tag.m_128379_("enableColour", this.enableColour);
            tag.m_128379_("enableEmblem", this.enableEmblem);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128441_("displayTier")) {
                this.displayTier = PatreonTier.values()[tag.m_128451_("displayTier")];
            }
            if (tag.m_128441_("enableColour")) {
                this.enableColour = tag.m_128471_("enableColour");
            }
            if (tag.m_128441_("enableEmblem")) {
                this.enableEmblem = tag.m_128471_("enableEmblem");
            }
        }

        public static PatreonDisplay fromNbt(CompoundTag tag) {
            PatreonDisplay display = new PatreonDisplay(null, false, false);
            display.deserializeNBT(tag);
            return display;
        }
    }
}

