/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.client.ClientPrestigePowersData;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerPrestigePowersData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerPrestige";
    private static final String ACTIVE_PRESTIGE_TAG = "ActivePrestige";
    private static final String ACTIVE_PRESTIGE_PLAYER_TAG = "Player";
    private static final String ACTIVE_PRESTIGE_LIST_TAG = "Active";
    private final Map<UUID, PrestigeTree> playerMap = new HashMap<UUID, PrestigeTree>();
    private final Set<UUID> scheduledMerge = new HashSet<UUID>();
    private final Map<UUID, Set<String>> pendingActiveRestores = new HashMap<UUID, Set<String>>();
    private PrestigeTree previous;

    public PrestigeTree getPowers(Player player) {
        return this.getPowers(player.m_142081_());
    }

    public PrestigeTree getPowers(UUID uuid) {
        return this.playerMap.computeIfAbsent(uuid, id -> (PrestigeTree)ModConfigs.PRESTIGE_POWERS.get().orElse(new PrestigeTree()).copy());
    }

    public void setPrestige(Player player, PrestigeTree prestigeTree) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            this.getPowers(player).getAll(LearnableSkill.class, Skill::isUnlocked).forEach(skill -> skill.onRemove(SkillContext.ofPrestige(serverPlayer)));
        }
        this.playerMap.put(player.m_142081_(), prestigeTree);
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            prestigeTree.getAll(LearnableSkill.class, Skill::isUnlocked).forEach(skill -> skill.onAdd(SkillContext.ofPrestige(serverPlayer)));
            prestigeTree.sync(SkillContext.ofPrestige(serverPlayer));
        }
        this.m_77762_();
    }

    public boolean m_77764_() {
        return true;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer()) {
            PlayerPrestigePowersData data = PlayerPrestigePowersData.get((ServerLevel)event.world);
            PrestigeTree current = ModConfigs.PRESTIGE_POWERS.get().orElse(null);
            if (data.previous != current && current != null) {
                data.previous = current;
                data.scheduledMerge.addAll(data.playerMap.keySet());
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer() && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerPrestigePowersData data = PlayerPrestigePowersData.get(player2.m_183503_());
            if (data.scheduledMerge.remove(player2.m_142081_())) {
                ModConfigs.PRESTIGE_POWERS.get().ifPresent(tree -> {
                    SkillContext context = SkillContext.ofPrestige(player2);
                    Skill merged = data.playerMap.get(player2.m_142081_()).mergeFrom((Skill)tree.copy(), context);
                    PrestigeTree result = (PrestigeTree)merged;
                    data.playerMap.put(player2.m_142081_(), result);
                    Set<String> restoreIds = data.pendingActiveRestores.remove(player2.m_142081_());
                    data.applyStoredActiveStates(result, restoreIds, context);
                    PlayerVaultStats stats = PlayerVaultStatsData.get((ServerLevel)player.f_19853_).getVaultStats((Player)player2);
                    stats.setPrestigePoints(context.getLearnPoints());
                    AttributeSnapshotHelper.getInstance().refreshSnapshotDelayed(player2);
                    result.sync(context);
                    data.m_77762_();
                });
            }
            if (!PrestigeHelper.arePrestigePowersDisabled((Player)player2)) {
                data.getPowers((Player)player2).onTick(SkillContext.ofPrestige(player2));
            }
        } else if (event.side.isClient() && !PrestigeHelper.arePrestigePowersDisabled(event.player)) {
            PlayerPrestigePowersData.clientTick(event.player);
        }
    }

    private static void clientTick(Player player) {
        ClientPrestigePowersData.getTree().onClientTick(SkillContext.ofPrestigeClient());
    }

    private static PlayerPrestigePowersData create(CompoundTag tag) {
        PlayerPrestigePowersData data = new PlayerPrestigePowersData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.playerMap.clear();
        this.scheduledMerge.clear();
        this.pendingActiveRestores.clear();
        ListTag playerList = nbt.m_128437_("Players", 8);
        ListTag prestigeList = nbt.m_128437_("Prestige", 10);
        Map<UUID, Set<String>> activeStates = this.readActivePrestigeStates(nbt);
        if (playerList.size() != prestigeList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            Adapters.SKILL.readNbt((Tag)prestigeList.m_128728_(i)).ifPresent(tree -> {
                if (tree instanceof PrestigeTree) {
                    PrestigeTree prestigeTree = (PrestigeTree)tree;
                    Set storedActiveIds = (Set)activeStates.get(playerUUID);
                    this.applyStoredActiveStates(prestigeTree, storedActiveIds, null);
                    if (storedActiveIds != null && !storedActiveIds.isEmpty()) {
                        this.pendingActiveRestores.put(playerUUID, new HashSet(storedActiveIds));
                    }
                    this.playerMap.put(playerUUID, prestigeTree);
                    this.scheduledMerge.add(playerUUID);
                }
            });
        }
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag prestigeList = new ListTag();
        ListTag activeList = new ListTag();
        this.playerMap.forEach((uuid, prestigeTree) -> Adapters.SKILL.writeNbt(prestigeTree).ifPresent(tag -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            prestigeList.add(tag);
            CompoundTag activeEntry = new CompoundTag();
            activeEntry.m_128359_(ACTIVE_PRESTIGE_PLAYER_TAG, uuid.toString());
            activeEntry.m_128365_(ACTIVE_PRESTIGE_LIST_TAG, (Tag)this.serializeActivePrestigeStates((PrestigeTree)prestigeTree));
            activeList.add((Object)activeEntry);
        }));
        nbt.m_128365_("Players", (Tag)playerList);
        nbt.m_128365_("Prestige", (Tag)prestigeList);
        if (!activeList.isEmpty()) {
            nbt.m_128365_(ACTIVE_PRESTIGE_TAG, (Tag)activeList);
        }
        return nbt;
    }

    private Map<UUID, Set<String>> readActivePrestigeStates(CompoundTag nbt) {
        HashMap<UUID, Set<String>> activeStates = new HashMap<UUID, Set<String>>();
        if (!nbt.m_128425_(ACTIVE_PRESTIGE_TAG, 9)) {
            return activeStates;
        }
        ListTag storedStates = nbt.m_128437_(ACTIVE_PRESTIGE_TAG, 10);
        for (Tag tag : storedStates) {
            CompoundTag compound;
            if (!(tag instanceof CompoundTag) || !(compound = (CompoundTag)tag).m_128425_(ACTIVE_PRESTIGE_PLAYER_TAG, 8)) continue;
            try {
                UUID playerId = UUID.fromString(compound.m_128461_(ACTIVE_PRESTIGE_PLAYER_TAG));
                ListTag activeIds = compound.m_128437_(ACTIVE_PRESTIGE_LIST_TAG, 8);
                HashSet<String> activeIdSet = new HashSet<String>();
                for (Tag activeId : activeIds) {
                    if (!(activeId instanceof StringTag)) continue;
                    StringTag stringTag = (StringTag)activeId;
                    activeIdSet.add(stringTag.m_7916_());
                }
                activeStates.put(playerId, activeIdSet);
            }
            catch (IllegalArgumentException e) {
                VaultMod.LOGGER.info("Skipping prestige activation data for invalid player id: {}", (Object)compound.m_128461_(ACTIVE_PRESTIGE_PLAYER_TAG));
            }
        }
        return activeStates;
    }

    private boolean applyStoredActiveStates(PrestigeTree tree, @Nullable Set<String> storedActiveStates, @Nullable SkillContext context) {
        Set<String> activeIds = storedActiveStates != null ? storedActiveStates : Collections.emptySet();
        boolean changed = false;
        List<TieredSkill> unlockedTiered = tree.getAll(TieredSkill.class, TieredSkill::isUnlocked);
        for (TieredSkill tiered : unlockedTiered) {
            LearnableSkill child;
            String tierId = tiered.getId();
            if (tierId == null || !((child = tiered.getChild()) instanceof ActivatePrestigePower)) continue;
            ActivatePrestigePower activatePrestigePower = (ActivatePrestigePower)child;
            boolean shouldBeActive = activeIds.contains(tierId);
            if (context == null) {
                if (activatePrestigePower.isActive() == shouldBeActive) continue;
                activatePrestigePower.setActive(shouldBeActive);
                changed = true;
                continue;
            }
            SkillContext callbackContext = context.copy();
            if (shouldBeActive) {
                if (!activatePrestigePower.isActive()) {
                    if (!activatePrestigePower.onEnable(callbackContext)) continue;
                    activatePrestigePower.setActive(true);
                    changed = true;
                    continue;
                }
                activatePrestigePower.onEnable(callbackContext);
                continue;
            }
            if (!activatePrestigePower.isActive() || !activatePrestigePower.onDisable(callbackContext)) continue;
            activatePrestigePower.setActive(false);
            changed = true;
        }
        return changed;
    }

    private ListTag serializeActivePrestigeStates(PrestigeTree prestigeTree) {
        ListTag activeIds = new ListTag();
        prestigeTree.getAll(TieredSkill.class, TieredSkill::isUnlocked).forEach(tiered -> {
            ActivatePrestigePower activatePrestigePower;
            LearnableSkill child = tiered.getChild();
            if (child instanceof ActivatePrestigePower && (activatePrestigePower = (ActivatePrestigePower)child).isActive() && tiered.getId() != null) {
                activeIds.add((Object)StringTag.m_129297_((String)tiered.getId()));
            }
        });
        return activeIds;
    }

    public static PlayerPrestigePowersData get(ServerLevel world) {
        return PlayerPrestigePowersData.get(world.m_142572_());
    }

    public static PlayerPrestigePowersData get(MinecraftServer srv) {
        return (PlayerPrestigePowersData)srv.m_129783_().m_8895_().m_164861_(PlayerPrestigePowersData::create, PlayerPrestigePowersData::new, DATA_NAME);
    }
}

